/*******************************************************************************
 * Copyright (c) 2005 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.browsing;

import com.adacore.gnatbench.core.internal.analyzer.AdaEntityReference;

/**
 * This class has to be implemented by widgets able to select an entity, e.g.
 * outline, text editor, etc.
 * 
 * @author Quentin Ochem
 */
public interface IAdaEntitySelectionProvider {
	
	/**
	 * Returns the entity currently selected.
	 * 
	 * @return
	 */
	public AdaEntityReference getEntitySelected();
}
