/*******************************************************************************
 * Copyright (c) 2005, 2008 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.analyzer;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/**
 * This interface is used to allow icons to be defined for constructs.
 * 
 */
public interface IAdaConstructIconProvider {

	/**
	 * Return the icon corresponding to the construct.
	 * 
	 * @param construct
	 * @return
	 */
	public Image getImage (AdaSimpleConstruct construct);
	
	public ImageDescriptor getImageDescriptor (AdaSimpleConstruct construct);
	
	/**
	 * Return the icon corresponding to the visibility / category association.
	 * 
	 * @param construct
	 * @return
	 */
	public Image getImage (int category, int visibility);
	
	public ImageDescriptor getImageDescriptor (int category, int visibility);
}
