/*******************************************************************************
 * Copyright (c) 2005 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/


package com.adacore.gnatbench.core.internal.analyzer;

/**
 * Classes that wants to be notified of the changes in the structure of a file
 * should implement this interface.
 * 
 * @author ochem
 */
public interface IAdaAnalyzerListener extends IAdaConstructFilterProvider {
    
	/**
	 * Called whenever an element is added to the analyzer tree. If the 
	 * element has children, elementAdded will *NOT* be called for them.
	 * 
	 * @param element
	 */
    public void elementAdded (AdaConstruct element);

	/**
	 * Called whenever an element is removed from the analyzer tree. If the 
	 * element has children, elementRemoved will *NOT* be called for them.
	 * 
	 * @param element
	 */
    public void elementRemoved (AdaConstruct element);
    
    /**
     * Called whenever an element is modified, e.g. its position or size has 
     * changed.
     * 
     * @param element
     */
    public void elementModified (AdaConstruct element);

    
    /**
     * Called before a batch of changes notification.
     *
     */
    public void startChangesBatch ();
    
    /**
     * Called after a batch of changes notification.
     *
     */
    public void finishedChangesBatch ();    
}
