/*******************************************************************************
 * Copyright (c) 2005 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.analyzer;

import java.util.LinkedList;

/**
 * This filter will try to analyze beyond blocked items. That means that a 
 * child, direct or indirect, of a blocked construct will be analyzed and 
 * considerated if it passes the filter.
 * 
 * @author Quentin Ochem
 */

public abstract class AdaConstructPassTroughFilter extends AdaConstructFilter {

	/**
	 * @param filter
	 */
	public AdaConstructPassTroughFilter(AdaConstructFilter filter) {
		super (filter);
	}
	
	/**
	 * @param filter
	 */
	public AdaConstructPassTroughFilter() {
		super ();
	}

	public final boolean internalFilter (AdaConstruct construct) {
		return simpleFilter(construct);
	}
	
	public void internalInitialize () {
	}
	
	protected LinkedList<AdaConstruct> internalFilterChildren(
			LinkedList<AdaConstruct> list) {
		LinkedList<AdaConstruct> result = new LinkedList<AdaConstruct>();

		for (AdaConstruct element : list) {
			if (simpleFilter(element)) {
				result.add(element);
			} else {
				result.addAll(internalFilterChildren(element
						.getChildrenList(null)));
			}
		}
		
		return result;		
	}
}
