/*******************************************************************************
 * Copyright (c) 2006, 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/
 
package com.adacore.gnatbench.core.internal.analyzer;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.preferences.AdaPreferencePage;
import com.adacore.gnatbench.core.internal.preferences.IGNATbenchPreferencesProvider;

/**
 * This class provides preferences for the analyzer job.
 */
public class AdaAnalyzerJobPreferencesProvider implements
		IGNATbenchPreferencesProvider {

	public static final String PREF_TOOLS_ANALYZER_TIMEOUT = 
		GNATbenchCorePlugin.getId() + ".preferences.tools.analyzer.timeout";
	
	public static final String PREF_TOOLS_ANALYZER_ENABLED = 
		GNATbenchCorePlugin.getId() + ".preferences.tools.analyzer.enabled";

	public void createPreferenceFields(AdaPreferencePage page) {
		page.addField(new BooleanFieldEditor(
				PREF_TOOLS_ANALYZER_ENABLED, 
				"Enable source analysis (outline and folding)",
				page.getFieldEditorParent()));
		page.addField(new IntegerFieldEditor(
				PREF_TOOLS_ANALYZER_TIMEOUT, 
				"Time of inactivity before analyzing the source (ms)",
				page.getFieldEditorParent()));
		
	}

	public void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault (PREF_TOOLS_ANALYZER_ENABLED, true);
		store.setDefault (PREF_TOOLS_ANALYZER_TIMEOUT, 1000);
	}

	public void okPerformed(AdaPreferencePage page) {
		// TODO Auto-generated method stub
		
	}
}
