/*******************************************************************************
 * Copyright (c) 2005, 2006 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.analyzer;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.UIJob;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

/**
 * This class is used to defer the call of the analyzer.
 * 
 * @author ochem
 */
public class AdaAnalyzerJob extends UIJob {
	
	private boolean fHasChanged = false;
	private boolean fScheduled = false;
	private AdaAnalyzer fAnalyzer = null;
	
	/**
	 * @param name The name of the job as displayed in the job view.
	 * @param analyzer The analyzer managed by this instance.
	 */
	public AdaAnalyzerJob(String name, AdaAnalyzer analyzer) {
		super(name);
		
		fAnalyzer = analyzer;
	}
	
	/**
	 * This function has to be called whenever a change occures in the managed
	 * buffer. It will reset the timer. If no time reset is done within a 
	 * customizable time range, then runUIThread will be allowed to call the
	 * analyzer.
	 *
	 */
	public void notifyChange() {
		if (!fScheduled) {
			fHasChanged = false;
			fScheduled = true;
			
			schedule(GNATbenchCorePlugin
					.getDefault()
					.getPreferenceStore()
					.getInt(
							AdaAnalyzerJobPreferencesProvider.PREF_TOOLS_ANALYZER_TIMEOUT));
		}
		else {
			fHasChanged = true;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.progress.UIJob#runInUIThread(org.eclipse.core.runtime.IProgressMonitor)
	 */
	public IStatus runInUIThread(IProgressMonitor monitor) {
		if (fHasChanged) {
			schedule(GNATbenchCorePlugin
					.getDefault()
					.getPreferenceStore()
					.getInt(
							AdaAnalyzerJobPreferencesProvider.PREF_TOOLS_ANALYZER_TIMEOUT));
			fScheduled = true;
		} else {

			if (GNATbenchCorePlugin
					.getDefault()
					.getPreferenceStore()
					.getBoolean(
							AdaAnalyzerJobPreferencesProvider.PREF_TOOLS_ANALYZER_ENABLED)) {
				fAnalyzer.analyze();
			}
			
			fScheduled = false;
		}
				
		fHasChanged = false;
		
		return new Status(IStatus.OK, GNATbenchCorePlugin.getId(), IStatus.OK,
				"", null);
	}
	
}
