/*******************************************************************************
 * Copyright (c) 2005 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/


package com.adacore.gnatbench.core.internal.adaeditor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;
/**
 * @author ochem
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class AdaPartitionScanner extends RuleBasedPartitionScanner {
    public final static String ADA_COMMENT = "__ada_comment"; //$NON-NLS-1$
    public final static String ADA_CHARACTER = "__ada_character";
    public final static String ADA_STRING = "__ada_string";
    
    
    public final static String[] ADA_PARTITION_TYPES= new String[]
       {ADA_COMMENT, ADA_CHARACTER, ADA_STRING};
        
    /**
     * Creates the partitioner and sets up the appropriate rules.
     */
    public AdaPartitionScanner() {
        super();

        IToken comment= new Token(ADA_COMMENT);
        IToken string = new Token (ADA_STRING);

        List <IRule> rules= new ArrayList <IRule>();

        rules.add(new EndOfLineRule("--", comment)); //$NON-NLS-1$
        
        rules.add (new AdaCharacterRule (string));
        
        rules.add (new AdaStringRule (string));
        
        IPredicateRule[] result= new IPredicateRule[rules.size()];
        rules.toArray(result);
        setPredicateRules(result);
    }

}
