/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.adaeditor;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.preferences.AdaPreferencePage;
import com.adacore.gnatbench.core.internal.preferences.IGNATbenchPreferencesProvider;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistryFactory;
import com.adacore.gnatbench.core.GNATbenchSession;

public class AdaEditorToolPreferencesProvider implements
		IGNATbenchPreferencesProvider {

	public static final String PREF_TOOLS_BLOC_FOLDING =
		GNATbenchCorePlugin.getId() + ".preferences.tools.bloc_folding";
	public static final String PREF_TOOLS_CODE_ASSIST =
		GNATbenchCorePlugin.getId() + ".preferences.tools.code_assist";
	public static final String PREF_TOOLS_CODE_ASSIST_AUTO_ACTIVATION =
		GNATbenchCorePlugin.getId() +
		".preferences.tools.code_assist_activation";
	public static final String PREF_TOOLS_CODE_ASSIST_DELAY =
		GNATbenchCorePlugin.getId() + ".preferences.tools.code_assist_delay";
	public static final String PREF_TOOLS_CODEFIX =
		GNATbenchCorePlugin.getId() + ".preferences.tools.codefix";


	public void createPreferenceFields(AdaPreferencePage page) {
		page.addField(new BooleanFieldEditor(
				PREF_TOOLS_BLOC_FOLDING,
				"Enable block folding",
				page.getFieldEditorParent()));

		BooleanFieldEditor codeAssistEditor = new BooleanFieldEditor(
				PREF_TOOLS_CODE_ASSIST,
				"Enable Code Assist",
				page.getFieldEditorParent());

		page.addField(codeAssistEditor);

		page.getPreferenceStore().addPropertyChangeListener(
				new IPropertyChangeListener() {
					public void propertyChange(PropertyChangeEvent event) {
						if (event.getProperty().equals(PREF_TOOLS_CODE_ASSIST)
								&& ((Boolean) (event.getNewValue()))
										.booleanValue()) {
							((GNATProjectRegistryFactory) GNATbenchSession
									.getDefault().getProjectRegistryFactory())
									.recomputeAllKernels();
						}
					}
				});

		page.addField(new BooleanFieldEditor(
				PREF_TOOLS_CODE_ASSIST_AUTO_ACTIVATION,
				"Enable Code Assist auto activation",
				page.getFieldEditorParent()));

		page.addField(new IntegerFieldEditor(
				PREF_TOOLS_CODE_ASSIST_DELAY,
				"Auto activation delay for Code Assist (ms)",
				page.getFieldEditorParent()));

		page.addField(new BooleanFieldEditor(
				PREF_TOOLS_CODEFIX,
				"Enable Quick Fixes",
				page.getFieldEditorParent()));
	}

	public void initializeDefaultPreferences(
			IPreferenceStore store) {
		store.setDefault (PREF_TOOLS_BLOC_FOLDING, true);
		store.setDefault (PREF_TOOLS_CODE_ASSIST, true);
		store.setDefault (PREF_TOOLS_CODE_ASSIST_AUTO_ACTIVATION, true);
		store.setDefault (PREF_TOOLS_CODE_ASSIST_DELAY, 200);
		store.setDefault (PREF_TOOLS_CODEFIX, true);
	}

	public void okPerformed(AdaPreferencePage page) {
		// TODO Auto-generated method stub

	}

}
