/*******************************************************************************
 * Copyright (c) 2005 AdaCore and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal.adaeditor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;

//import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;

/**
 * This class holds the main functionalities of the ada-aware editor.
 * 
 * @author ochem
 */
public abstract class AbstractAdaEditor extends TextEditor {
	
	private GeneralizedFile fFile;
	private IDocument fDocument = null;
	private AdaDocumentBuffer fDocumentBuffer = null;
	
	public AbstractAdaEditor () {
		GNATbenchCorePlugin.getDefault().registerEditor(this);			
	}
	
	public IProject getProject() {
		return fFile.getProject ();
	}
	
	public GeneralizedFile getFile() {
		return fFile;
	}
	
	public IDocument getDocument () {
		return fDocument;
	}
	
	public AdaDocumentBuffer getDocumentBuffer() {
		return fDocumentBuffer;
	}
	
	public void doSetInput(IEditorInput input) throws CoreException {
		super.doSetInput(input);
		
		fFile = GeneralizedFile.fromEditorInput(input);
			
		fDocumentBuffer = new AdaDocumentBuffer(fFile);

		GNATbenchCorePlugin.getDefault().removeBuffer(fFile);
		
		fDocument = fFile.getDocument();
	}
	
	public IDocumentProvider getDocumentProvider() {
		return GNATbenchCorePlugin.getDefault().getDocumentProvider();
	}
	
	public void dispose() {
		GNATbenchCorePlugin.getDefault().unregisterEditor(this);
		fDocumentBuffer.dispose();
		
		super.dispose();		
	}
}