/*******************************************************************************
 * Copyright (c) 2006, 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;

import com.adacore.gnatbench.core.internal.preferences.AdaPreferencePage;
import com.adacore.gnatbench.core.internal.preferences.IGNATbenchPreferencesProvider;

public class GPSPreferencesProvider implements IGNATbenchPreferencesProvider {

	public static final String PREF_GPS_LAUNCH_COMMAND = 
		GNATbenchCorePlugin.getId()	+ ".preferences.gps.lauchcommand";
	
	private static final String DEFAULT_PREF_GPS_LAUCH_COMMAND = "gps";
	
	public void createPreferenceFields(AdaPreferencePage page) {
		page.addField(new StringFieldEditor(PREF_GPS_LAUNCH_COMMAND,
				"GPS command", page.getFieldEditorParent()));
	}

	public void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(PREF_GPS_LAUNCH_COMMAND,
				DEFAULT_PREF_GPS_LAUCH_COMMAND);
	}

	public void okPerformed(AdaPreferencePage page) {
		// TODO Auto-generated method stub
		
	}
}
