/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal;

import java.io.IOException;

import org.eclipse.core.runtime.Platform;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.library.LibraryMonitor;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.Standard.AdaString;

public class GPS {

	/**
	 * Launch gps on the given project, with the python file given in
	 * parameter. Python files are supposed to be in the src/python directory
	 * of com.adacore.gnatbench.core plugin.
	 *
	 * If extra args is not null, then they will be appened at the end of the
	 * argument list.
	 *
	 * @param pythonFile
	 * @param project
	 * @return
	 */
	static public Process launchGPS(GPRProject project, String pythonFile,
			String extraArgs) {
		Process GPSProcess = null;

		String launchCommand = GNATbenchCorePlugin.getDefault()
		.getPreferenceStore().getString(
				GPSPreferencesProvider.PREF_GPS_LAUNCH_COMMAND);

		String commandGPS = null;

		LibraryMonitor libMonitor = LibrarySemaphore.startGPSWork();

		try {
			commandGPS = launchCommand
					+ " -P \""
					+ project.getGPRProject().Project_Path(new AdaString(""))
							.Full_Name(false) + "\" --load=python:\""
					+ GNATbenchCorePlugin.getDefault().getPluginPath()
					+ "src/python/" + pythonFile + "\"";
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);

			return null;
		} finally {
			LibrarySemaphore.stopGPSWork(libMonitor);
		}

		if (extraArgs != null) {
			commandGPS = commandGPS + " " + extraArgs;
		}

		try {
			if (Platform.getOS().equals("win32")) {
				GPSProcess = Runtime.getRuntime().exec(
						"cmd /c \"" + commandGPS + "\"");

			} else {
				GPSProcess = Runtime.getRuntime().exec (
						new String[] { "sh", "-c", commandGPS });
			}
		} catch (IOException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);

			return null;
		}

		return GPSProcess;
	}

}
