/*******************************************************************************
 * Copyright (c) 2007, 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.core.internal;

import org.eclipse.core.runtime.jobs.ISchedulingRule;

import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;

/**
 * This rule will avoid two jobs working at the same time on a given kernel.
 */
public class GNATbenchKernelRule implements ISchedulingRule {

	private GNATProjectRegistry fKernel;
	
	public GNATbenchKernelRule (GNATProjectRegistry kernel) {
		fKernel = kernel;
	}
	
	public boolean contains(ISchedulingRule rule) {		
		if (!(rule instanceof GNATbenchKernelRule)) {
			return false;
		}
		
		return fKernel == ((GNATbenchKernelRule) rule).fKernel;
	}

	public boolean isConflicting(ISchedulingRule rule) {
		if (!(rule instanceof GNATbenchKernelRule)) {
			return false;
		}
		
		return fKernel == ((GNATbenchKernelRule) rule).fKernel;
	}

}
