/*****************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.osgi.framework.Bundle;

import com.adacore.gnatbench.core.internal.preferences.IGNATbenchPreferencesProvider;

public class AdaPreferencesInitializer extends AbstractPreferenceInitializer {

	public void initializeDefaultPreferences() {
		IExtensionRegistry er = Platform.getExtensionRegistry();
		IExtensionPoint ep = er.getExtensionPoint(GNATbenchCorePlugin
				.getId(), "preference");

		IExtension[] extensions = ep.getExtensions();

		if (extensions.length == 0) {
			return;
		}

		for (int extInd = 0; extInd < extensions.length; ++extInd) {

			IConfigurationElement[] elements = extensions[extInd]
					.getConfigurationElements();

			for (int i = 0; i < elements.length; ++i) {
				if (elements[i].getName().equals("provider")) {
					try {
						Bundle bundle = Platform
								.getBundle(extensions[extInd]
										.getNamespaceIdentifier());

						IGNATbenchPreferencesProvider preferenceProvider =
							(IGNATbenchPreferencesProvider) bundle
								.loadClass(
										elements[i].getAttribute("class"))
								.newInstance();

						preferenceProvider
								.initializeDefaultPreferences
								(GNATbenchCorePlugin.getDefault().getPreferenceStore());
					} catch (InvalidRegistryObjectException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} catch (InstantiationException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} catch (IllegalAccessException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					} catch (ClassNotFoundException e) {
						GNATbenchCorePlugin.getDefault().logError(null, e);
					}
				}
			}
		}
	}
}
