/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.analyzer;

import org.eclipse.core.runtime.IProgressMonitor;

/**
 * This class represents a reference to an Ada entity, and provides 
 * semantic-aware capabilities.
 * 
 * Some of these capabilities need the files to be compiled and the ALI files
 * produced to be completely accurate.
 * 
 * This interface is not intended to be implemented by clients.
 * 
 * @since 2.2
 */
public interface IAdaEntityReference {

	/**
	 * Possible scopes for semantic-aware search functions
	 */
	public enum SearchScopes {
		SCOPE_PROJECT, SCOPE_PROJECT_HIERARCHY, SCOPE_WORKSPACE
	};
	
	/**
	 * Return the offset where this reference is located.
	 */
	public int getOffset ();
	
	/**
	 * Return the ada document holding this reference.
	 */
	public IAdaDocument getAdaDocument ();
	
	/**
	 * Return the declaration of this entity reference. If it cannot be found,
	 * then return null. 
	 */
	public IAdaEntityReference getDeclaration ();
	
	/**
	 * Iterates over the references of this entity in the scope given in
	 * parameter.
	 */
	public Iterable <IAdaEntityReference> getReferences(SearchScopes scope,
			IProgressMonitor monitor);
	
}
