/*****************************************************************************
 * Copyright (c) 2008 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core.analyzer;

import org.eclipse.jface.text.IDocument;

/**
 * This is the entry point of all semantic-aware functionalities of GNATbench.
 * 
 * This interface is not intended to be implemented by clients.
 * 
 * @since 2.2
 */
public interface IAdaDocument {

	/**
	 * Return the document corresponding to this ada document.
	 */
	public IDocument getDocument ();
	
	/**
	 * Return a reference to the entity located at this offset in the document,
	 * null if none. 
	 */
	public IAdaEntityReference getEntity (int offset);
	
}
