/*****************************************************************************
 * Copyright (C) 2008-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.core;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import com.adacore.gnatbench.core.analyzer.IAdaDocument;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.analyzer.GeneralizedFile;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistryFactory;
import com.adacore.gnatbench.core.projects.IGNATProjectRegistry;
import com.adacore.gnatbench.core.projects.IGNATProjectRegistryFactory;

/**
 * This class holds global variables that are available across the whole
 * GNATbench session.
 *
 * @since 2.2
 */
public final class GNATbenchSession {

	private IGNATProjectRegistryFactory projectRegFactory = new GNATProjectRegistryFactory();

	private static GNATbenchSession fgDefault;

	private GNATbenchSession () {

	}

	/**
	 * Return the default GNATbench session associated with the current Eclipse
	 * session - creates one if none.
	 */
	public static GNATbenchSession getDefault () {
		if (fgDefault == null) {
			fgDefault = new GNATbenchSession ();
		}

		return fgDefault;
	}

	/**
	 * Return a registry referencing the project given in parameter - creating
	 * one if needed.
	 *
	 * Shortcut for getProjectRegistryFactory.getOrLoadRegistry (project)
	 */
	public IGNATProjectRegistry getOrLoadRegistry(IProject project) {
		return projectRegFactory.getOrLoadRegistry(project);
	}

	/**
	 * Return the project registry factory used for this session.
	 */
	public IGNATProjectRegistryFactory getProjectRegistryFactory () {
		return projectRegFactory;
	}

	/**
	 * Return the ada document that corresponds to the file given in parameter.
	 */
	public IAdaDocument getAdaDocument(IFile file) {
		return getAdaDocument (file.getLocation());
	}

	/**
	 * Return the ada document that corresponds to the file given in parameter.
	 */
	public IAdaDocument getAdaDocument(IFileStore file) {
		return getAdaDocument (URIUtil.toPath(file.toURI()));
	}

	/**
	 * Return the ada document that corresponds to the path given in parameter.
	 * This path is expected to be a full OS location.
	 */
	public IAdaDocument getAdaDocument(IPath path) {
		return GNATbenchCorePlugin.getDefault().getDocumentBuffer(
				GeneralizedFile.fromOSPath(null, path.toOSString()));
	}
}
