/*******************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal.wizards.newelement;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.dialogs.WizardNewFolderMainPage;
import org.eclipse.ui.wizards.newresource.BasicNewFolderResourceWizard;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.GNATbenchProjectProperties;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.internal.utils.DisplayUtils;

public class NewAdaSourceFolderWizard
	extends BasicNewFolderResourceWizard
	implements INewWizard
{

	private ImageDescriptor logo = ImageDescriptor.createFromImage(
			GNATbenchUIPlugin
				.getDefault()
				.getImage(GNATbenchUIPlugin.ADACORE_LOGO));


	public void addPages() {
		super.addPages();
		IWizardPage page = getStartingPage();
		page.setTitle("Create New Ada Source Folder");
		page.setDescription("The new source folder will be added " +
				"to the GNAT project file automatically.");
		page.setImageDescriptor(logo);
	} // addPages


	public boolean performFinish() {
		if (super.canFinish()) {
			IFolder folder = ((WizardNewFolderMainPage) getStartingPage()).createNewFolder();
			return updateGPRFile(folder);
		} else {
			return false;
		} // if
	} // performFinish


    protected boolean updateGPRFile(final IFolder folder) {
    	final IProject project = folder.getProject();
		final GPRProject gprProject = ((GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(project)).getGPRFor(project);
		final String newSourceFolderName = folder.getLocation().toString();
    	try {
    		String [] currentSourceDirs;
    		try {
    			currentSourceDirs = gprProject.getAttributeAsList("Source_Dirs", "", "");
    			// this should not raise C_E but does, currently, so we code around it
    			// with this exception handler
			} catch (Throwable e) {
				currentSourceDirs = null;
			}
    		if (currentSourceDirs == null) {
    			String [] newSourceDirs = { ".", newSourceFolderName };
    			gprProject.setAttributeValue("Source_Dirs", "", "", newSourceDirs);
    		} else {
    			String [] newSourceDirs = new String [currentSourceDirs.length+1];
    			for (int k = 0; k < currentSourceDirs.length; k++) {
    				newSourceDirs[k] = currentSourceDirs[k];
    			} // for
    			newSourceDirs [newSourceDirs.length-1] = newSourceFolderName;
    			gprProject.setAttributeValue("Source_Dirs", "", "", newSourceDirs);
    		} // if

			final GNATbenchProjectProperties props = GNATbenchProjectProperties.getPropertiesFor(project);
			final String gprFileName = new Path(props.getGPROSPath()).lastSegment();
			final IFile projectFile = project.getFile(gprFileName);
			gprProject.save(projectFile);
    		return true;
    	} catch (Throwable e) {
    		DisplayUtils.displayError(
    				"Create Ada Source Folder",
    				"Could not add source folder to GNAT project file.\n" +
    				e.getLocalizedMessage());
    		GNATbenchCorePlugin.getDefault().logError(null, e);
    		try {
				folder.delete(true, new NullProgressMonitor());
	    		return false;
			} catch (CoreException e1) {
	    		DisplayUtils.displayError(
	    				"Create Ada Source Folder Recovery",
	    				"Could not delete folder.\n" +
	    				e1.getLocalizedMessage());
	    		GNATbenchCorePlugin.getDefault().logError(null, e1);
	    		return false;
			}
    	} // try
    } // updateGPRFile

} // NewAdaSourceFolderWizard
