/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal.wizards.newProject;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class NewAdaDebugReleaseProject extends AbstractNewAdaProject {

	public void addPages() {
		super.addPages();

		newProjPage.setDescription(
				"A project with scenarios for building debug and release versions.\n" +
				"Specify the name of the new project and where it will be located.");
		newProjPage.setTitle("New Ada Debug/Release Project");
		addPage(newProjPage);

		mainPage = new AdaMainPage("Ada Main Program Settings");
		addPage(mainPage);

		builderPage = new AdaBuilderPage("Ada Builder Settings");
		addPage(builderPage);
	} // addPages


	protected boolean createGPRfile(
			final String projectName,
			final String mainUnitName,
			final String builderName)
	{
		final String projFileName = new String (projectName + ".gpr");

		final IFile file = newProject.getFile(new Path (projFileName));

		final String languageChoice;
		if (builderPage.useAda2005()) {
			languageChoice = ", \"-gnat05\"";
		} else {
			languageChoice = "";
		} // if

		final String mainAttribute;
		if (mainUnitName.equals("")) {
			mainAttribute = "";
		} else {
			mainAttribute = tab(1) + "for Main use (\"" + mainUnitName + ".adb\");\n\n";
		} // if

		if (!file.exists()) {
			final String newGPRfile =
				"project " + projectName + " is\n" +
				"\n" +
				tab(1) + "type Build_Modes is (\"Release\", \"Debug\");\n" +
			    tab(1) + "Mode : Build_Modes := external (\"BUILD\", \"Debug\");\n" +
				"\n" +
				mainAttribute +

				tab(1) + "for Exec_Dir use \".\";\n"+
				"\n" +
				tab(1) + "case Mode is\n"+
				tab(2) + "when \"Debug\" =>\n"+
				tab(3) + "for Object_Dir use \"debug_objs\";\n"+
				tab(2) + "when \"Release\" =>\n"+
				tab(3) + "for Object_Dir use \"release_objs\";\n"+
				tab(1) + "end case;\n"+
				"\n" +
				tab(1) + "package Compiler is\n" +
				tab(2) + "case Mode is\n" +
				tab(3) + "when \"Debug\" =>\n" +
				tab(4) + "for Default_Switches (\"Ada\") use\n" +
				tab(6) + "(\"-g\", \"-gnato\", \"-gnatwa\", \"-fstack-check\"" + languageChoice + ");\n" +
				tab(3) + "when \"Release\" =>\n" +
				tab(4) + "for Default_Switches (\"Ada\") use (\"-O2\"" + languageChoice + ");\n" +
				tab(2) + "end case;\n" +
				tab(1) + "end Compiler;\n" +
				"\n" +
				tab(1) + "package Builder is\n" +
				tab(2) + "case Mode is\n" +
				tab(3) + "when \"Debug\" =>\n" +
				tab(4) + "for Default_Switches (\"Ada\") use (\"-g\");\n" +
				tab(3) + "when \"Release\" =>\n" +
				tab(4) + "for Default_Switches (\"Ada\") use (\"\");\n" +
				tab(2) + "end case;\n" +
				tab(1) + "end Builder;\n" +
				"\n" +
				tab(1) + "package IDE is\n" +
				tab(2) + "for Compiler_Command(\"Ada\") use \"" + builderName + "\";\n" +
				tab(1) + "end IDE;\n" +
				"\n" +
				"end " + projectName + ";";

			try {
				file.create(new ByteArrayInputStream(newGPRfile.getBytes()), true, null);
			} catch (CoreException e) {
				displayError("Create GNAT project",
						"Inserting project file '" + projFileName +
						"' to project " + projectName + " failed");
				GNATbenchCorePlugin.getDefault().logError(null, e);
			} // try
		} // if
		return true;
	} // createGPRfile


	protected boolean setupProject(
			final IProject project,
			final String mainUnitName,
			final String builderName)
	{
		final IFolder debugFolder = newProject.getFolder(new Path ("debug_objs"));

		try {
			debugFolder.create(true, true, null);
		} catch (CoreException e) {
			displayError("Create GNAT project",
					"Inserting debug object dir to project " +
					project.getName() +
					" failed");
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} // try

		final IFolder releaseFolder = newProject.getFolder(new Path ("release_objs"));

		try {
			releaseFolder.create(true, true, null);
		} catch (CoreException e) {
			displayError("Create GNAT project",
					"Inserting release object dir to project " +
					project.getName() +
					" failed");
			GNATbenchCorePlugin.getDefault().logError(null, e);
		} // try

		return true;
	} // setupProject


} // NewAdaDebugReleaseProject
