/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal.wizards.newProject;

import java.io.ByteArrayInputStream;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class NewAdaConfigurableProject extends AbstractNewAdaProject {

	protected AdaObjsPage objsPage;


	public NewAdaConfigurableProject() {
		super();
	} // NewAdaConfigurableProject


	public void addPages() {
		super.addPages();

		newProjPage.setDescription("A fully user-configurable project.\n" +
				"Specify the name of the new project and " +
				"where it will be located.");
		newProjPage.setTitle("New Ada Configurable Project");
		addPage(newProjPage);

		mainPage = new AdaMainPage("Ada Main Program Settings");
		addPage(mainPage);

		objsPage = new AdaObjsPage("Ada Build Products Settings");
		addPage(objsPage);

		builderPage = new AdaBuilderPage("Ada Builder Settings");
		addPage(builderPage);
	} // addPages


	protected boolean allPagesComplete() {
		if (!super.allPagesComplete()) {
			return false;
		} // if
		if (!objsPage.isPageComplete()) {
			return false;
		} // if
		return true;
	} // allPagesComplete


	protected boolean createGPRfile(
			final String projectName,
			final String mainUnitName,
			final String builderName)
	{
		final String projFileName = new String (projectName + ".gpr");

		final IFile file = newProject.getFile(new Path (projFileName));

		final String languageChoice;
		if (builderPage.useAda2005()) {
			languageChoice = ", \"-gnat05\"";
		} else {
			languageChoice = "";
		} // if

		final String mainAttribute;
		if (mainUnitName.equals("")) {
			mainAttribute = "";
		} else {
			mainAttribute = tab(1) + "for Main use (\"" + mainUnitName + ".adb\");\n\n";
		} // if

		final String objsAttribute;
		if (objsPage.objectDirName().equals("")) {
			objsAttribute = "";
		} else {
			objsAttribute = tab(1) + "for Object_Dir use \"" + objsPage.objectDirName() + "\";\n\n";
		} // if

		final String execAttribute;
		if (objsPage.executableDirName().equals(objsPage.defaultExecutableDirName()) ||
			objsPage.executableDirName().equals("")) {
			execAttribute = "";
		} else {
			execAttribute = tab(1) + "for Exec_Dir use \"" + objsPage.executableDirName() + "\";\n\n";
		} // if

		if (!file.exists()) {
			final String newGPRfile =
				"project " + projectName + " is\n" +
				"\n" +
				mainAttribute +

				execAttribute +

				objsAttribute +

				tab(1) + "package Compiler is\n" +
				tab(2) + "for Default_Switches (\"Ada\") use\n" +
				tab(4) + "(\"-g\", \"-gnato\", \"-gnatwa\", \"-fstack-check\"" + languageChoice + ");\n" +
				tab(1) + "end Compiler;\n" +
				"\n" +
				tab(1) + "package Builder is\n" +
				tab(2) + "for Default_Switches (\"Ada\") use (\"-g\", \"-gnatQ\");\n" +
				tab(1) + "end Builder;\n" +
				"\n" +
				tab(1) + "package IDE is\n" +
				tab(2) + "for Compiler_Command(\"Ada\") use \"" + builderName + "\";\n" +
				tab(1) + "end IDE;\n" +
				"\n" +
				"end " + projectName + ";";

			try {
				file.create(new ByteArrayInputStream(newGPRfile.getBytes()), true, null);
			} catch (CoreException e) {
				displayError("Create GNAT project",
						"Adding project file '" + projFileName +
						"' to project " + projectName + " failed");
				GNATbenchCorePlugin.getDefault().logError(null, e);
			} // try

		} // if
		return true;
	} // createGPRfile


	protected boolean setupProject(
			final IProject project,
			final String mainUnitName,
			final String builderName)
	{
		IFolder folder;

		if (!objsPage.objectDirName().equals("")) {
			folder = newProject.getFolder(new Path (objsPage.objectDirName()));
			if (!folder.exists()) {
				try {
					folder.create(true, true, null);
				} catch (CoreException e) {
					displayError("Create GNAT Project",
							"Creating object direcory for project " +
							project.getName() +
							" failed");
					GNATbenchCorePlugin.getDefault().logError(null, e);
					return false;
				} // try
			} // if
		} // if

		if (!objsPage.executableDirName().equals(objsPage.defaultExecutableDirName()) &&
			!objsPage.executableDirName().equals("") &&
			!objsPage.executableDirName().equals("."))
		{
			folder = newProject.getFolder(new Path (objsPage.executableDirName()));
			if (!folder.exists()) {
				try {
					folder.create(true, true, null);
				} catch (CoreException e) {
					displayError("Create GNAT Project",
							"Creating executable direcory for project " +
							project.getName() +
							" failed");
					GNATbenchCorePlugin.getDefault().logError(null, e);
					return false;
				} // try
			} // if
		} // if

		return true;
	} // setupProject


} // NewAdaConfigurableProject
