/*******************************************************************************
 * Copyright (c) 2006 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal.wizards.newProject;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class AdaObjsPage extends WizardPage {
	
	private Text   objsDirWidget;
	private String objsDirName = "objs";
	private Text   execDirWidget;
	private String execDirName = defaultExecutableDirName();
	
	private ImageDescriptor logo = ImageDescriptor.createFromImage(
			GNATbenchUIPlugin
				.getDefault()
				.getImage(GNATbenchUIPlugin.ADACORE_LOGO));


	
	public AdaObjsPage(String pageName) {
		super (pageName);
		this.setTitle(pageName);
		this.setDescription("Specify the folders to contain object files and " +
				"executables. If no executable folder is specified, the executable " +
				"will appear in the same folder as the object files.  If neither " +
				"is specified, all products will be located in the project " +
				"root folder."); 
		this.setImageDescriptor(logo);
	} // AdaMainPage
	
	
	public String objectDirName() {
		return objsDirName;
	} // objectDirName
	
	public String executableDirName() {
		return execDirName;
	} // executableDirName

	public String defaultExecutableDirName() {
		return "(same as intermediate products)";
	} // defaultExecutableDirName
	
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            objsDirWidget.setFocus();
        } // if
    } // SetVisible

    
	public void createControl(Composite parent) {
		Composite baseComp = new Composite(parent, SWT.NONE);
		setControl(baseComp);

		GridLayout topLayout = new GridLayout();
		baseComp.setLayout(topLayout);

		Composite mainProgComp = new Composite(baseComp, SWT.NONE);
		GridLayout locationLayout = new GridLayout();
		locationLayout.numColumns = 2;
		locationLayout.marginHeight = 1;
		locationLayout.marginWidth = 1;
		mainProgComp.setLayout(locationLayout);
		
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		mainProgComp.setLayoutData(gd);
				
		Label mainUnitLabel = new Label(mainProgComp, SWT.NONE);
		mainUnitLabel.setText("Intermediate Product Folder:");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		mainUnitLabel.setLayoutData(gd);

		objsDirWidget = new Text(mainProgComp, SWT.SINGLE | SWT.BORDER);

		objsDirWidget.setText("objs");
		
		objsDirWidget.addModifyListener(new ModifyListener () {

			public void modifyText(ModifyEvent e) {
				objsDirName = new String (((Text) e.getSource()).getText().trim());				
			}});
		
		gd = new GridData(GridData.FILL_HORIZONTAL);
		objsDirWidget.setLayoutData(gd);
		
		
		Label execDirLabel = new Label(mainProgComp, SWT.NONE);
		execDirLabel.setText("Executable Product Folder:");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		execDirLabel.setLayoutData(gd);

		execDirWidget = new Text(mainProgComp, SWT.SINGLE | SWT.BORDER);
		
		execDirWidget.setText(defaultExecutableDirName());
		
		execDirWidget.addModifyListener(new ModifyListener () {

			public void modifyText(ModifyEvent e) {
				execDirName = new String (((Text) e.getSource()).getText().trim());				
			}});
		
		gd = new GridData(GridData.FILL_HORIZONTAL);
		execDirWidget.setLayoutData(gd);
	}	

} // AdaObjsPage
