/*******************************************************************************
 * Copyright (c) 2006 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal.wizards.newProject;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.adacore.gnatbench.core.internal.utils.SyntaxUtils;
import com.adacore.gnatbench.ui.internal.GNATbenchUIPlugin;

public class AdaMainPage extends WizardPage {
	
	private Text   unitNameWidget;
	private String fmainUnitName = "";
	private Button fCreateMainProgramFile;
	private Button mainIsHelloWorld;

	private ImageDescriptor logo = ImageDescriptor.createFromImage(
			GNATbenchUIPlugin
				.getDefault()
				.getImage(GNATbenchUIPlugin.ADACORE_LOGO));

	
	public AdaMainPage(String pageName) {
		super (pageName);
		this.setTitle(pageName);
		this.setDescription(
				"Enter the name of the Ada main subprogram, if there will be one.\n" +
				"A main is not required. You may also have the wizard generate a \n" +
				"file containing that subprogram.");
		this.setImageDescriptor(logo);
	} // AdaMainPage
	
	
	public boolean shouldCreateMainFile() {
		return fCreateMainProgramFile.getSelection();
	} // shouldCreateMainFile
		
	public boolean requestedHelloWorld() {
		return mainIsHelloWorld.getSelection();
	} // requestedHelloWorld
	
	
	public String unitName() {
		return properlyCasedName(fmainUnitName);
	} // unitName
	
	
    public boolean isPageComplete() {
    	return (!shouldCreateMainFile() ? true : SyntaxUtils.isAdaIdentifier(fmainUnitName));    			
    } // isPageComplete
	

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            unitNameWidget.setFocus();
        } // if
    } // SetVisible
    
    
    protected String properlyCasedName(final String name) {
    	// eventually we'll need to take the package Naming into account
    	// but for now we just ensure the name is in lower case
    	return name.toLowerCase();
    } // properlyCasedName

    
	public void createControl(Composite parent) {
		Composite baseComp = new Composite(parent, SWT.NONE);
		setControl(baseComp);

		GridLayout topLayout = new GridLayout();
		baseComp.setLayout(topLayout);

		Composite mainProgComp = new Composite(baseComp, SWT.NONE);
		GridLayout locationLayout = new GridLayout();
		locationLayout.numColumns = 2;
		locationLayout.marginHeight = 1;
		locationLayout.marginWidth = 1;
		mainProgComp.setLayout(locationLayout);
		
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		mainProgComp.setLayoutData(gd);
				
		// the part for getting the name of the main subprogram

		Label mainUnitLabel = new Label(mainProgComp, SWT.NONE);
		mainUnitLabel.setText("Name of the Ada main subprogram unit (not the file name):");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		mainUnitLabel.setLayoutData(gd);

		unitNameWidget = new Text(mainProgComp, SWT.SINGLE | SWT.BORDER);
		
		unitNameWidget.addModifyListener(new ModifyListener () {

			public void modifyText(ModifyEvent e) {
				fmainUnitName = new String (((Text) e.getSource()).getText().trim());
				
				if (fmainUnitName.equals("")) {
					// clear any prior error message about this
					setErrorMessage(null);
					fCreateMainProgramFile.setEnabled(false);
					return;
				} // if
				
				if (!fmainUnitName.equals("") && !SyntaxUtils.isAdaIdentifier(fmainUnitName)) {
					setErrorMessage("Main subprogram names must conform to Ada identifier rules");
					return;
				} else {
					// clear any prior error message about this
					setErrorMessage(null);
				} // if	
				
				fCreateMainProgramFile.setEnabled(true);

		        if (isCurrentPage()) {
		            getContainer().updateButtons();
		        } // if
			}});
		
		gd = new GridData(GridData.FILL_HORIZONTAL);
		unitNameWidget.setLayoutData(gd);
		
		
		// do they want us to generate the main subprogram?
				
		fCreateMainProgramFile = new Button (mainProgComp, SWT.CHECK);
		fCreateMainProgramFile.setText("Generate the file containing that Ada main subprogram");
//		fCreateMainProgramFile.setSelection(true);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 2;
		fCreateMainProgramFile.setLayoutData(gd);	
		fCreateMainProgramFile.setEnabled(false);
		
		// should this main program be the Hello World program?
		
		mainIsHelloWorld  = new Button (mainProgComp, SWT.CHECK);
		mainIsHelloWorld.setText("Generate Ada main subprogram as Hello World application");
		mainIsHelloWorld.setSelection(false);
		gd = new GridData();
		gd.horizontalSpan = 2;
		mainIsHelloWorld.setLayoutData(gd);
		mainIsHelloWorld.setEnabled(fCreateMainProgramFile.getSelection());

		// we enable the option to generate a Hello World version of the main
		// subprogram only if we are generating the main in the first place.
		fCreateMainProgramFile.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e) {}
			public void widgetSelected(SelectionEvent e) {
				mainIsHelloWorld.setEnabled(fCreateMainProgramFile.getSelection());
				if (isCurrentPage()) {
					getContainer().updateButtons();
				} // if
			}			
		});

	} // createControl	

} // AdaMainPage
