/*******************************************************************************
 * Copyright (c) 2006 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal.wizards.conversion;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;

import com.adacore.gnatbench.cdt.internal.wizards.newProject.AdaBuilderPage;
import com.adacore.gnatbench.cdt.internal.wizards.newProject.AdaMainPage;
import com.adacore.gnatbench.cdt.internal.wizards.newProject.NewAdaBasicProject;

public class ConvertedAdaProjectWizard extends NewAdaBasicProject { 


	public ConvertedAdaProjectWizard() {
		super();
	} // ConvertedAdaProjectWizard
	
	
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		super.init(workbench, selection);
		
		if (selection instanceof IStructuredSelection) {			
			IStructuredSelection sel = (IStructuredSelection) selection;
			Object obj = sel.getFirstElement();			
			newProject = (IProject)obj;
		} // if
	} // init


	public void addPages() {
		mainPage = new AdaMainPage("Ada Main Program Settings for the Converted Project"); 
		addPage(mainPage);
		builderPage = new AdaBuilderPage("Ada Builder Settings for the Converted Project"); 
		addPage(builderPage);
	} // addPages
	
	
	public boolean performFinish() {
		if (!allPagesComplete()) {
			return false;
		} // if

		if (!createGPRfile(newProject.getName(), mainPage.unitName(), builderPage.builderName())) {
			return false;			
		} // if
		
		if (!createMakefile(newProject, 
				builderPage.isForeignBuilder(),
				builderPage.getForeignBuildCommand(),
				builderPage.getForeignCleanCommand(),
				builderPage.getForeignAnalyzeCommand(),
				builderPage.getForeignAutoBuildCommand())) 
		{
			return false;
		} // if
		
		if (!setupProject(newProject, mainPage.unitName(), builderPage.builderName())) {
			return false;			
		} // if
		
		if (mainPage.shouldCreateMainFile()) {
			if (!createMainFile(mainPage.unitName(), mainPage.requestedHelloWorld())) {
				return false;
			} // if
		} // if
		
		return true;
	} // performFinish
	
	
} // ConvertedAdaProjectWizard
