/*******************************************************************************
 * Copyright (C) 2005-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal.adaeditor;

import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.model.ICLineBreakpoint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.FileEditorInput;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.ui.internal.adaeditor.AdaEditor;

public class CDTAdaEditor extends AdaEditor {

	protected ISourceViewer createSourceViewer(Composite parent,
			IVerticalRuler ruler, int styles) {

		ISourceViewer viewer = super.createSourceViewer(parent, ruler, styles);

		final IVerticalRuler fRuler = ruler;

		ruler.getControl().addMouseListener(new MouseListener() {

			public void mouseDoubleClick(MouseEvent e) {
				try {
					String sourceHandle = getFile().getOSPath();

					FileEditorInput f = ((FileEditorInput) getEditorInput());

					ICLineBreakpoint br = CDIDebugModel.lineBreakpointExists(
							sourceHandle, f.getFile(), fRuler
									.getLineOfLastMouseButtonActivity() + 1);
					if (br == null) {
						CDIDebugModel.createLineBreakpoint(sourceHandle, f
								.getFile(), fRuler
								.getLineOfLastMouseButtonActivity() + 1, true,
								0, "", true);
					} else {
						br.delete();
					}
				} catch (CoreException e1) {
					GNATbenchCorePlugin.getDefault().logError(null, e1);
				}
			}

			public void mouseDown(MouseEvent e) {
			}

			public void mouseUp(MouseEvent e) {
			}
		});

		return viewer;

	}
}
