package com.adacore.gnatbench.cdt.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;

import com.adacore.gnatbench.cdt.internal.wizards.newProject.NewAdaConfigurableProject;


public class NewConfigurableAdaProjectAction extends Action implements IWorkbenchWindowPulldownDelegate {

    private IWorkbenchWindow window;

    
    public NewConfigurableAdaProjectAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    } // NewConfigurableAdaProjectAction

    
    public NewConfigurableAdaProjectAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        } // if
        this.window = window;
    } // NewConfigurableAdaProjectAction


    public void run() {
    	NewAdaConfigurableProject wizard = new NewAdaConfigurableProject();

		IWorkbench workbench = PlatformUI.getWorkbench();

		ISelection selection = window.getSelectionService().getSelection();

		IStructuredSelection selectionToPass = StructuredSelection.EMPTY;
		if (selection instanceof IStructuredSelection)
			selectionToPass = (IStructuredSelection) selection;
		wizard.init(workbench, selectionToPass);

		wizard.setForcePreviousAndNextButtons(true);

		WizardDialog dialog = new WizardDialog(null, wizard);
		dialog.create();
		dialog.open();
	} // run


	public Menu getMenu(Control parent) {
		// TODO Auto-generated method stub
		return null;
	}


	public void dispose() {
		// TODO Auto-generated method stub
		
	}


	public void init(IWorkbenchWindow window) {
		// TODO Auto-generated method stub
		
	}


	public void run(IAction action) {
		run();
	}


	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub
		
	}
    
} // NewConfigurableAdaProjectAction
