/*****************************************************************************
 * Copyright (C) 2007-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.cdt.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

import com.adacore.gnatbench.cdt.internal.GNATbenchCDTPlugin;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class NewAdaSourceFolderPulldownAction implements IWorkbenchWindowPulldownDelegate  {

	protected IWorkbenchWindow window;
	protected IWorkbench       workbench;
	protected Menu             menu;


	public NewAdaSourceFolderPulldownAction() {
	} // NewAdaFilePulldownAction


	public void init(IWorkbenchWindow window) {
		this.window = window;
		workbench = window.getWorkbench();
	} // init


	public Menu getMenu(Control parent) {
		// TODO move all this menu construction to init() since need only be done once.

		menu = new Menu(parent);

		MenuItem menuitem = new MenuItem(menu, SWT.NONE);
		menuitem.setText("Ada Source Folder");
		menuitem.setImage(GNATbenchCDTPlugin.getDefault().getImage(GNATbenchCDTPlugin.NEW_ADA_FOLDER));
		menuitem.setData(new NewAdaSourceFolderAction(window));
		addListener(menuitem);

		menuitem = new MenuItem(menu, SWT.NONE);
		menuitem.setText("Folder");
		menuitem.setImage(GNATbenchCDTPlugin.getDefault().getImage(GNATbenchCDTPlugin.NEW_FOLDER));
		menuitem.setData(new NewBasicFolderAction(window));
		addListener(menuitem);

		return menu;
	} // getMenu


	protected void addListener(MenuItem menuitem) {
		menuitem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				IAction action = (IAction) e.widget.getData();
				try {
					action.run();
				} catch (Exception e1) {
					GNATbenchCorePlugin.getDefault().logError(null, e1);
				} // try
			} // widgetSelected
		});
	} // addListener


	public void run(IAction action) {
		new NewAdaSourceFolderAction(window).run();
	} // run


	public void selectionChanged(IAction action, ISelection selection) {
	} // selectionChanged


	public void dispose() {
	} // dispose

} // NewAdaSourceFolderAction