/*******************************************************************************
 * Copyright (c) 2007 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;

import com.adacore.gnatbench.cdt.internal.wizards.newelement.NewAdaSourceFolderWizard;

public class NewAdaSourceFolderAction 
	extends Action 
	implements IWorkbenchWindowPulldownDelegate 
{

    private IWorkbenchWindow window;
    
    public NewAdaSourceFolderAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    } // NewBasicFileAction

    
    public NewAdaSourceFolderAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        } // if
        this.window = window;
    } // NewBasicFileAction


    public void run() {
    	NewAdaSourceFolderWizard wizard = new NewAdaSourceFolderWizard();

		IWorkbench workbench = PlatformUI.getWorkbench();

		ISelection selection = window.getSelectionService().getSelection();

		IStructuredSelection selectionToPass = StructuredSelection.EMPTY;
		if (selection instanceof IStructuredSelection)
			selectionToPass = (IStructuredSelection) selection;
		wizard.init(workbench, selectionToPass);

		WizardDialog dialog = new WizardDialog(null, wizard);
		dialog.create();
		dialog.open();
	} // run


	public Menu getMenu(Control arg0) {
		// TODO Auto-generated method stub
		return null;
	}


	public void dispose() {
		// TODO Auto-generated method stub
		
	}


	public void init(IWorkbenchWindow arg0) {
		// TODO Auto-generated method stub
		
	}


	public void run(IAction arg0) {
		// TODO Auto-generated method stub
		
	}


	public void selectionChanged(IAction arg0, ISelection arg1) {
		// TODO Auto-generated method stub
		
	}
    
} // NewBasicFileAction
