package com.adacore.gnatbench.cdt.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

import com.adacore.gnatbench.cdt.internal.GNATbenchCDTPlugin;

public class NewAdaProjectPulldownAction implements IWorkbenchWindowPulldownDelegate  {
	
	protected IWorkbenchWindow window;
	protected IWorkbench       workbench;
	protected Menu             menu;

	
	public NewAdaProjectPulldownAction() {
	} // NewAdaProjectPulldownAction


	public void init(IWorkbenchWindow window) {
		this.window = window;
		workbench = window.getWorkbench();
	} // init

	
	public Menu getMenu(Control parent) {
		// TODO move all this menu construction to init() since need only be done once.

		menu = new Menu(parent);

		MenuItem menuitem = new MenuItem(menu, SWT.NONE);			
		menuitem.setText("Ada Project");
		menuitem.setImage(GNATbenchCDTPlugin.getDefault().getImage(GNATbenchCDTPlugin.NEW_ADA_PROJ));
		menuitem.setData(new NewConfigurableAdaProjectAction(window));	
		addListener(menuitem);

		MenuItem menuitem1 = new MenuItem(menu, SWT.NONE);			
		menuitem1.setText("Ada Project with Objects Folder");
		menuitem1.setImage(GNATbenchCDTPlugin.getDefault().getImage(GNATbenchCDTPlugin.NEW_ADA_PROJ));
		menuitem1.setData(new NewBasicAdaProjectAction(window));	
		addListener(menuitem1);
		
		MenuItem menuitem2 = new MenuItem(menu, SWT.NONE);		
		menuitem2.setText("Ada Project with Debug and Release Scenarios");
		menuitem2.setImage(GNATbenchCDTPlugin.getDefault().getImage(GNATbenchCDTPlugin.NEW_ADA_PROJ));
		menuitem2.setData(new NewDebugReleaseAdaProjectAction(window));		
		addListener(menuitem2);		
			
		return menu;
	} // getMenu
	
	
	protected void addListener(MenuItem menuitem) {
		menuitem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				IAction action = (IAction) e.widget.getData();
				try {
					action.run();
				} catch (Exception e1) {
					e1.printStackTrace();
				} // try
			} // widgetSelected
		});		
	} // addListener

	
	public void run(IAction action) {
		new NewConfigurableAdaProjectAction(window).run();
	} // run

	
	public void selectionChanged(IAction action, ISelection selection) {
	} // selectionChanged

	
	public void dispose() {
	} // dispose

} // NewAdaProjectPulldownAction