/*****************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *****************************************************************************/

package com.adacore.gnatbench.cdt.internal.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.cdt.internal.GNATbenchCDTPlugin;

public class NewAdaFilePulldownAction implements IWorkbenchWindowPulldownDelegate  {

	protected IWorkbenchWindow window;
	protected IWorkbench       workbench;
	protected Menu             menu;


	public NewAdaFilePulldownAction() {
	} // NewAdaFilePulldownAction


	public void init(IWorkbenchWindow window) {
		this.window = window;
		workbench = window.getWorkbench();
	} // init


	public Menu getMenu(Control parent) {
		// TODO move all this menu construction to init() since need only be done once.

		menu = new Menu(parent);

		MenuItem menuitem = new MenuItem(menu, SWT.NONE);
		menuitem.setText("Ada Source File");
		menuitem.setImage(GNATbenchCDTPlugin.getDefault().getImage(GNATbenchCDTPlugin.NEW_ADA_FILE));
		menuitem.setData(new NewAdaFileAction(window));
		addListener(menuitem);

		menuitem = new MenuItem(menu, SWT.NONE);
		menuitem.setText("File");
		menuitem.setImage(GNATbenchCDTPlugin.getDefault().getImage(GNATbenchCDTPlugin.NEW_FILE));
		menuitem.setData(new NewBasicFileAction(window));
		addListener(menuitem);

		return menu;
	} // getMenu


	protected void addListener(MenuItem menuitem) {
		menuitem.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				IAction action = (IAction) e.widget.getData();
				try {
					action.run();
				} catch (Exception e1) {
					GNATbenchCorePlugin.getDefault().logError(null, e1);
				} // try
			} // widgetSelected
		});
	} // addListener


	public void run(IAction action) {
		new NewAdaFileAction(window).run();
	} // run


	public void selectionChanged(IAction action, ISelection selection) {
	} // selectionChanged


	public void dispose() {
	} // dispose

} // NewAdaFilePulldownAction