package com.adacore.gnatbench.cdt.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;

import com.adacore.gnatbench.cdt.internal.wizards.newelement.NewAdaSourceFileWizard;


public class NewAdaFileAction extends Action implements IWorkbenchWindowPulldownDelegate {

    private IWorkbenchWindow window;

    
    public NewAdaFileAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    } // NewBasicFileAction

    
    public NewAdaFileAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        } // if
        this.window = window;
    } // NewBasicFileAction


    public void run() {
    	NewAdaSourceFileWizard wizard = new NewAdaSourceFileWizard();

		IWorkbench workbench = PlatformUI.getWorkbench();

		ISelection selection = window.getSelectionService().getSelection();

		IStructuredSelection selectionToPass = StructuredSelection.EMPTY;
		if (selection instanceof IStructuredSelection)
			selectionToPass = (IStructuredSelection) selection;
		wizard.init(workbench, selectionToPass);

		wizard.setForcePreviousAndNextButtons(true);

		WizardDialog dialog = new WizardDialog(null, wizard);
		dialog.create();
		dialog.open();
	} // run


	public Menu getMenu(Control parent) {
		// TODO Auto-generated method stub
		return null;
	}


	public void dispose() {
		// TODO Auto-generated method stub
		
	}


	public void init(IWorkbenchWindow window) {
		// TODO Auto-generated method stub
		
	}


	public void run(IAction action) {
		run();
	}


	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub
		
	}
    
} // NewBasicFileAction
