/*******************************************************************************
 * Copyright (c) 2006 AdaCore.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.console.IConsoleConstants;

public class GNATbenchPerspectiveFactory implements IPerspectiveFactory {
	
	private static final String ProjectExplorer = 
	    "com.adacore.gnatbench.ui.projectexplorer.ProjectExplorer";

	private static final String ScenarioVars = 
	    "com.adacore.gnatbench.ui.ScenarioVariablesView";

	public void createInitialLayout(IPageLayout layout) {
		
		String editorArea = layout.getEditorArea();
		
		IFolderLayout topLeft = layout.createFolder(
				"topLeft", 
				IPageLayout.LEFT, 
				0.25f, 
				editorArea);
		topLeft.addView(ProjectExplorer);
		topLeft.addView(IPageLayout.ID_RES_NAV);
		
		IFolderLayout bottom = layout.createFolder(
				"bottom", 
				IPageLayout.BOTTOM, 
				0.75f, 
				editorArea); 
		bottom.addView(IPageLayout.ID_PROBLEM_VIEW);
//		bottom.addView(IPageLayout.ID_TASK_LIST);
		bottom.addView(IConsoleConstants.ID_CONSOLE_VIEW);  
		bottom.addView(ScenarioVars);
		
		IFolderLayout topRight = layout.createFolder(
				"topRight", 
				IPageLayout.RIGHT, 
				0.75f, 
				editorArea);
		topRight.addView(IPageLayout.ID_OUTLINE);
		
		// Place the wizards into the "file/new" menu and "new" toolbar locations between 
		// "Project" and "Other".
		// TODO: these id's should really be constants somewhere...
		layout.addNewWizardShortcut("com.adacore.gnatbench.cdt.wizards.newProject.NewAdaConfigurableProject");
		layout.addNewWizardShortcut("com.adacore.gnatbench.cdt.wizards.newProject.NewAdaDebugReleaseProject");
		layout.addNewWizardShortcut("com.adacore.gnatbench.cdt.wizards.newProject.NewAdaBasicProject");
		layout.addNewWizardShortcut("com.adacore.gnatbench.cdt.wizards.newelement.NewAdaSourceFileWizard");
		layout.addNewWizardShortcut("com.adacore.gnatbench.cdt.wizards.newelement.NewAdaSourceFolderWizard");
		layout.addNewWizardShortcut("com.adacore.gnatbench.cdt.wizards.newelement.BasicNewFileWizard");
		layout.addNewWizardShortcut("com.adacore.gnatbench.cdt.wizards.newelement.BasicNewFolderWizard");
	} // createInitialLayout

} // GNATbenchPerspectiveFactory
