/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal;
import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;

public class GNATbenchCDTPlugin extends AbstractUIPlugin {

	private static GNATbenchCDTPlugin plugin;

	public static final String NEW_ADA_PROJ = "new_ada_project";
	public static final String NEW_ADA_FILE = "new_ada_file";
	public static final String NEW_ADA_FOLDER = "new_ada_folder";
	public static final String NEW_FOLDER = "new_folder";
	public static final String NEW_FILE = "new_file";

	public GNATbenchCDTPlugin() {
		super();

		plugin = this;
	}

	/**
	 * Returns the shared instance.
	 */
	public static GNATbenchCDTPlugin getDefault() {
		return plugin;
	}

	public void start(BundleContext context) throws Exception {
		super.start(context);

		addImage(NEW_ADA_PROJ,  "img/", "newadaprj_wiz.gif");
		addImage(NEW_ADA_FILE, "img/", "newadafile_wiz.gif");
		addImage(NEW_ADA_FOLDER, "img/", "newadafldr_wiz.gif");
		addImage(NEW_FOLDER, "img/", "newbasicfolder_wiz.gif");
		addImage(NEW_FILE, "img/", "newbasicfile_wiz.gif");
	}

	/**
	 * Adds an image to the image registery. The image is then stored during the
	 * whole life of the plugin. Never create any image directly (will cost a
	 * lot of memory
	 *
	 * @param key
	 * @param basePath
	 * @param name
	 */
	public void addImage(String key, String basePath, String name) {
		getImageRegistry().put(key, createImage(basePath, name));
	}


	/**
	 * Returns an image that has been set by addImage.
	 *
	 * @param key
	 * @return
	 */
	public Image getImage(String key) {
		return getImageRegistry().get(key);
	}


	/**
	 * Returns a descriptor based on a path and a name.
	 *
	 * @param basePath
	 * @param name
	 * @return
	 */
	public ImageDescriptor getImageDescriptor(String basePath, String name) {
		URL baseURL;

		try {
			baseURL = new URL(getBundle().getEntry(basePath), name);
		} catch (MalformedURLException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);

			return null;
		}

		return ImageDescriptor.createFromURL(baseURL);
	}


	/**
	 * Create an image based on a path and a name. If such an image cannot be
	 * found, then returns null.
	 *
	 * @param basePath
	 * @param name
	 * @return
	 */
	private Image createImage(String basePath, String name) {
		return getImageDescriptor(basePath, name).createImage();
	}

}
