/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;

import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.builder.GNATbenchIncrementalBuilder;
import com.adacore.gnatbench.core.internal.builder.IGNATbenchProjectNatureContribution;

public class GNATbenchCDTNatureContribution implements
		IGNATbenchProjectNatureContribution {

	public void configure(IProject project) {
		try {

			enableCDTDebugger(project);

			//  add the GNATbench builder

			IProjectDescription desc = project.getDescription();
			ICommand[] commands = desc.getBuildSpec();
			boolean found = false;

			for (int i = 0; i < commands.length; ++i) {
				if (commands [i].getBuilderName().equals
						(GNATbenchIncrementalBuilder.BUILDER_ID)) {
					found = true;
					break;
				}
			}

			if (!found) {
				ICommand command = desc.newCommand();
				command.setBuilderName(GNATbenchIncrementalBuilder.BUILDER_ID);
				ICommand[] newCommands = new ICommand[commands.length + 1];

				System.arraycopy(commands, 0, newCommands, 1, commands.length);
				newCommands[0] = command;
				desc.setBuildSpec (newCommands);
				project.setDescription (desc, null);
			}

		} catch (CoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}
	}


	// Do all that is necessary to the project so that the CDT debugger will
	// work with our Ada executables.
	private void enableCDTDebugger(IProject project) throws CoreException {

		// The CDT debugger only recognizes C/C++ projects.
		CProjectNature.addCNature(project, new NullProgressMonitor ());

		// enable binary parsers so that the debugger will recognize our executables.

		ICDescriptor desc = CCorePlugin.getDefault().getCDescriptorManager().getDescriptor(project);

		desc.remove(CCorePlugin.BINARY_PARSER_UNIQ_ID);
		enableAllBinaryParsers(project, desc);

	} // enableCDTDebugger


	private void enableAllBinaryParsers(IProject project, ICDescriptor descriptor) throws CoreException {
		IExtensionPoint ep = Platform.getExtensionRegistry()
			.getExtensionPoint(CCorePlugin.PLUGIN_ID, CCorePlugin.BINARY_PARSER_SIMPLE_ID);
		if (ep != null) {
			IExtension[] extensions = ep.getExtensions();
			for (int k = 0; k < extensions.length; k++) {
				descriptor.create(CCorePlugin.BINARY_PARSER_UNIQ_ID,
						(extensions[k].getUniqueIdentifier()));
			} // for
		} // if
	} // enaleAllBinaryParsers


} // GNATbenchCDTNatureContribution
