/*******************************************************************************
 * Copyright (C) 2006-2009, AdaCore
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     AdaCore - Initial API and implementation
 *******************************************************************************/

package com.adacore.gnatbench.cdt.internal;

import org.eclipse.core.resources.IProject;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchSession;
import com.adacore.gnatbench.core.internal.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.internal.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.internal.projects.GNATProjectRegistry;
import com.adacore.gnatbench.core.internal.toolchain.IGNATbenchToolChain;

public class GNATToolChain implements IGNATbenchToolChain {

	public String name (final IProject project) {
		return compilerFromProject(project);
	} // name


	public String[] buildCommand (final IProject project) {
		String [] result = {compilerFromProject(project), "-d"};
		return result;
		// note: the "-d" switch causes gnatmake to output progress info lines
		// that we filter before showing in the build console and is required
		// for the percentage completion info to be shown in the progress monitor.
	} // buildCommand


	public String[] compileCommand (final IProject project) {
		String [] result = {compilerFromProject(project), "-c", "-u"};
		return result;
	} // compileCommand


	public String[] gnatlsCommand (final IProject project) {
		final GPRProject gprProject = ((GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(project)).getGPRFor(project);
		try {
			final String gnatls = gprProject.getAttributeValue ("Gnatlist", "IDE", "");
			if ((gnatls != null) && (!gnatls.equals(""))) {
				String [] result = {gnatls};
				return result;
			} // if
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}
		// there is no gnatls attribute specified so we get it from the compiler name
		final String compilerName = compilerFromProject(project);
		if (compilerName.equalsIgnoreCase("gprbuild")) {
			// TODO: determine what to return...
		} // if
		final int last = compilerName.lastIndexOf("make");
		if (last != -1) {
			final String toolNamePrefix = compilerName.substring(0,last);
			String [] result = {toolNamePrefix + "ls"};
			return result;
		}
		// the name was not of the form <prefix>-gnatmake so we have no
		// way to deduce it.
		String [] result = {compilerName + "gnatls"};
		return result;
	} // gnatlsCommand


	protected String compilerFromProject(final IProject project) {
		final GPRProject gprProject = ((GNATProjectRegistry) GNATbenchSession
				.getDefault().getOrLoadRegistry(project)).getGPRFor(project);
		String compilerName = null;

		try {
			compilerName = gprProject.getAttributeValue ("compiler_command", "IDE", "ada");
		} catch (GNATbenchCoreException e) {
			GNATbenchCorePlugin.getDefault().logError(null, e);
		}

		// when there is no IDE package, the user must be using the
		// native version of the compiler, which is named "gnatmake"
		if (compilerName == null) {
			return "gnatmake";
		} else {
			return compilerName;
		}
	} // compilerFromProject


} // GNATToolChain
