import GPS
import types

def debugger_terminated (hook_name, debugger):
	GPS.Socket ("ECLIPSE").send ("DEBUGGER_TERMINATED[MESSAGE]")

ECLIPSE_CLOSE_GPS = False

def closing_gps (hook_name):
	if not ECLIPSE_CLOSE_GPS:
		GPS.Socket ("ECLIPSE").send ("CLOSE_GPS[MESSAGE]")
		return False
	else:
		return True

def initializeHooks():
	GPS.Hook ("debugger_terminated").add (debugger_terminated)
	GPS.Hook ("before_exit_action_hook").add (closing_gps)

def getReferencesCommand (name, file, line, column):
   return GPS.Entity (name, GPS.File (file), line, column).references (True, False)
	
def isCommandFinished (id):
   return id.progress () ['current'] == id.progress () ['total']

def getReferencesCommandResult (id):
	refs = id.get_result()
	res = ""
	res = res + "["
	comma = ""
	for f in refs:
		res = res + comma
		res = res + f.file ().name ()
		res = res + ":"
		res = res + str (f.line ())
		res = res + ":"
		res = res + str (f.column ())
		comma = ", "
	res = res + "]"
	return res 

def getSpecAndBody (entity):
	res = "["

	try:
		spec = entity.declaration()
		res = res + spec.file().name() + ":" + str(spec.line()) + ":" + str(spec.column())
	except:
		res = res + "::"

	res = res + ", "

	try:
		body = entity.body()
		res = res + body.file().name() + ":" + str(body.line()) + ":" + str(body.column())
	except:
		res = res + "::"		

	res = res + "]"

	return res

def serializeCallReferences (refs):
	if refs == None:
		return "[]"
		
	res = ""
	
	for entity in refs:
		res = res + "["
		
		if isinstance (refs [entity], types.ListType):
			comma = ""
			for location in refs [entity]:
				res = res + comma
				res = res + location.file().name()
				res = res + ":" + str (location.line())
				res = res + ":" + str (location.column())
				comma=", "
		else:
			location = refs [entity]
			res = res + location.file().name()
			res = res + ":" + str (location.line())
			res = res + ":" + str (location.column())
		
		res = res + "]"

	return res

def getCalls (name, file, line, column):
	refs = GPS.Entity (name, GPS.File (file), line, column).calls ()
	return serializeCallReferences (refs)

def getCalledBy (name, file, line, column):
	refs = GPS.Entity (name, GPS.File (file), line, column).called_by ()
	return serializeCallReferences (refs)
	
def closeGPSEditors ():
	for ed in GPS.EditorBuffer.list():
		ed.close()
	   
def with (file, recursive):
	deps = file.imports (recursive)
	res = "["
	comma = ""
	
	for dep in deps:
		res += comma + dep.name() 
		comma = ", "
		
	return res + "]"
	
def withed_by (file, recursive):
	deps = file.imported_by (recursive)
	res = "["
	comma = ""
	
	for dep in deps:
		res += comma + dep.name() 
		comma = ", "
		
	return res + "]"