/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.jni;

import com.adacore.jni.AdaObject;
import com.adacore.jni.ObjectRef;

public class AdaString
extends AdaObject {
    private String fInternalString = null;

    public AdaString(String str) {
        this.fInternalString = str;
    }

    public AdaString(int[] addr) {
        this.adaAccess = addr;
    }

    public String toString() {
        if (this.fInternalString == null) {
            this.fInternalString = AdaString.extractStringOfAccess(this.adaAccess);
        }
        return this.fInternalString;
    }

    public int[] getAccess() {
        if (this.adaAccess == null) {
            this.adaAccess = AdaString.createStringAccessForString(this.toString());
            this.isOwned = true;
        }
        return this.adaAccess;
    }

    public ObjectRef NewObjectRef() {
        Ref ref = new Ref();
        ref.setValue(this);
        return ref;
    }

    protected void finalize() {
        if (this.isOwned && this.adaAccess != null) {
            AdaString.free(this.adaAccess);
        }
    }

    private static native String extractStringOfAccess(int[] var0);

    private static native int[] createStringAccessForString(String var0);

    private static native void free(int[] var0);

    public static class Ref
    implements ObjectRef {
        public AdaString ref;

        public void setValue(Object r) {
            this.ref = (AdaString)r;
        }

        public Object getValue() {
            return this.ref;
        }
    }
}

