/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.windriver.wizards.newProject;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.builder.GNATbenchProjectNature;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.windriver.SupportedTargets;
import com.adacore.gnatbench.windriver.wizards.newProject.AdaMainPage;
import com.windriver.ide.util.IBuildSpecAccessor;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class AbstractNewAdaProject
extends Wizard
implements INewWizard {
    protected AdaMainPage AdaMain;
    protected IProject newProject;
    static /* synthetic */ Class class$0;

    public void addPages() {
        this.AdaMain = new AdaMainPage("Ada Main Suprogram Settings");
        this.addPage((IWizardPage)this.AdaMain);
    }

    protected abstract IProject getNewProject();

    public boolean performFinish() {
        if (this.newProject == null) {
            IBuildSpecAccessor buildSpec;
            String defaultBuildSpec;
            this.newProject = this.getNewProject();
            if (this.newProject == null) {
                return false;
            }
            IProject a = this.newProject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.windriver.ide.util.IBuildSpecAccessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!SupportedTargets.includes(defaultBuildSpec = (buildSpec = (IBuildSpecAccessor)a.getAdapter((Class)clazz)).getDefaultBuildSpec())) {
                this.displayInfo("Unsupported Target", "Warning: " + defaultBuildSpec + " is not recognized as a supported AdaCore target.\n" + "Before you build, you may need to change the active build spec.");
            }
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    GNATbenchProjectNature.addNature((IProject)AbstractNewAdaProject.this.newProject);
                }
                catch (CoreException e) {
                    AbstractNewAdaProject.this.displayError("Create New Ada Project", "Adding nature failed");
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                    return;
                }
                if (!AbstractNewAdaProject.this.setGPRproperties()) {
                    return;
                }
                if (!AbstractNewAdaProject.this.createGPRfile(AbstractNewAdaProject.this.newProject.getName(), AbstractNewAdaProject.this.AdaMain.unitName())) {
                    return;
                }
                if (!AbstractNewAdaProject.this.setupProject(AbstractNewAdaProject.this.newProject, AbstractNewAdaProject.this.AdaMain.unitName())) {
                    return;
                }
                if (AbstractNewAdaProject.this.AdaMain.createFile() && !AbstractNewAdaProject.this.createMainFile(AbstractNewAdaProject.this.AdaMain.unitName())) {
                    return;
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayError("Create New Ada Project", "Project creation failed");
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean setGPRproperties() {
        GPRProject.setRootProject((IProject)this.newProject, (boolean)true);
        String projPath = String.valueOf(this.newProject.getName()) + ".gpr";
        GPRProject.setGPRPath((IProject)this.newProject, (String)projPath);
        return true;
    }

    protected boolean setupProject(IProject project, String mainUnitName) {
        IFolder folder = this.newProject.getFolder((IPath)new Path("debug_objs"));
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            this.displayError("Create GNAT Project", "Creating object direcory for project " + project.getName() + " failed");
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return false;
        }
        folder = this.newProject.getFolder((IPath)new Path("production_objs"));
        try {
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            this.displayError("Create GNAT Project", "Creating object direcory for project " + project.getName() + " failed");
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            return false;
        }
        return true;
    }

    protected boolean createGPRfile(String projectName, String mainUnitName) {
        String projFileName = new String(String.valueOf(projectName) + ".gpr");
        IFile file = this.newProject.getFile((IPath)new Path(projFileName));
        if (!file.exists()) {
            String newGPRfile = "project " + projectName + " is\n" + "\n" + "\ttype Mode_Type is (\"Production\", \"Debug\");\n" + "\tMode : Mode_Type := external (\"BUILD\", \"Debug\");\n" + "\n" + "\tfor Main use (\"" + mainUnitName + ".adb\");\n" + "\n" + "\tcase Mode is\n" + "\t\twhen \"Debug\" =>\n" + "\t\t\tfor Object_Dir use \"debug_objs\";\n" + "\t\twhen \"Production\" =>\n" + "\t\t\tfor Object_Dir use \"production_objs\";\n" + "\tend case;\n" + "\n" + "\tpackage Compiler is\n" + "\t\tcase Mode is\n" + "\t\t\twhen \"Debug\" =>\n" + "\t\t\t\tfor Default_Switches (\"Ada\") use\n" + "\t\t\t\t\t\t(\"-g\", \"-gnato\", \"-fstack-check\");\n" + "\t\t\twhen \"Production\" =>\n" + "\t\t\t\tfor Default_Switches (\"Ada\") use (\"-O2\");\n" + "\t\tend case;\n" + "\tend Compiler;\n" + "\n" + "\tpackage Builder is\n" + "\t\tcase Mode is\n" + "\t\t\twhen \"Debug\" =>\n" + "\t\t\t\tfor Default_Switches (\"Ada\") use\n" + "\t\t\t\t\t\t(\"-g\");\n" + "\t\t\twhen \"Production\" =>\n" + "\t\t\t\tnull;\n" + "\t\tend case;\n" + "\tend Builder;\n" + "\n" + "end " + projectName + ";";
            try {
                file.create((InputStream)new StringBufferInputStream(newGPRfile), true, null);
            }
            catch (CoreException e) {
                this.displayError("Create GNAT project", "Adding project file '" + projFileName + "' to project " + projectName + " failed");
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected boolean createMainFile(String mainUnitName) {
        String mainFileName = new String(String.valueOf(mainUnitName) + ".adb");
        IFile file = this.newProject.getFile((IPath)new Path(mainFileName));
        if (!file.exists()) {
            String newMainContent = "procedure " + mainUnitName + " is\n" + "begin\n" + "   null; -- remove this null statement and enter your code here\n" + "end " + mainUnitName + ";";
            try {
                file.create((InputStream)new StringBufferInputStream(newMainContent), true, null);
            }
            catch (CoreException e) {
                this.displayError("Create GNAT project", "Adding main program file '" + mainFileName + "' to project " + this.newProject.getName() + " failed");
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected void displayInfo(String title, String msg) {
        MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)msg);
    }

    protected void displayError(String title, String msg) {
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)msg);
    }

    class NewProjectListener
    implements IResourceChangeListener {
        private IProject newProject = null;

        NewProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (delta.getKind() == 1) {
                    this.newProject = (IProject)resource;
                }
                ++i;
            }
        }

        public IProject getNewProject() {
            return this.newProject;
        }
    }
}

