/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.windriver;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.builder.GNATbenchProjectNature;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

public class GPRSpy
implements IResourceChangeListener,
IResourceDeltaVisitor {
    static int fConversionPolicy;
    static final int YES = 0;
    static final int NO = 1;
    static final int NEVER = 2;

    public void resourceChanged(IResourceChangeEvent event) {
        if (fConversionPolicy == 2) {
            return;
        }
        switch (event.getType()) {
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    break;
                }
                catch (CoreException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        final IResource res = delta.getResource();
        switch (delta.getKind()) {
            case 1: {
                if (res.getProject().getFile(".wrproject").exists() && !res.getProject().hasNature(GNATbenchProjectNature.NATURE_ID) && "gpr".equals(res.getFileExtension())) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MessageDialog dialog = new MessageDialog(null, "GNAT Project Added to the Workspace", null, "The File " + res.getName() + " has been added to the workspace in a" + " non-GNATbench project. Do you want to" + " setup it for GNATbench now?", 3, new String[]{"Yes", "No", "Never"}, 1);
                            fConversionPolicy = dialog.open();
                        }
                    });
                    if (fConversionPolicy == 0) {
                        new WorkspaceJob("configure GNATbench project"){

                            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                                IProject project = res.getProject();
                                GNATbenchProjectNature.addNature((IProject)project);
                                project.refreshLocal(2, null);
                                GPRProject.setGPRPath((IProject)project, (String)res.getFullPath().removeFirstSegments(1).toOSString());
                                GNATbenchKernel.getDefault().fullWorkspaceRecompute();
                                return GNATbenchCorePlugin.OK_STATUS;
                            }
                        }.schedule();
                    }
                }
                return true;
            }
            case 2: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }
}

