/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.windriver;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.builder.IGNATbenchProjectNatureContribution;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GNATbenchWRNatureContribution
implements IGNATbenchProjectNatureContribution {
    static final String ADA_MAKEFILE_CONTENT = "FORCE:\n\n$(OBJ_DIR)/%.adaobject : $(SRC_DIR)/%.gpr FORCE\n\t@if [ `basename $< .gpr` = `basename $(PRJ_ROOT_DIR)` ]; then \\\n\t   echo \"building Ada project $<\";\\\n\t   gnatwrapper \"$<\" -o \"$@\" -s $(BUILD_SPEC); \\\n\telse\\\n\t   touch $@;\\\n\tfi\n\nSUB_OBJECTS:=${filter-out %.adaobject, $(SUB_OBJECTS)}\nOBJECTS:=${filter-out %.adaobject, $(OBJECTS)} ${filter %$(notdir $(basename $(PRJ_ROOT_DIR))).adaobject, $(OBJECTS)}\n\n\nexternal_clean::\n\t@if [ `echo $(BUILD_SPEC) | cut -c1-3` = \"PPC\" ]; then \\\n\t   powerpc-wrs-vxworks-gnatclean -q -r -P `basename $(PRJ_ROOT_DIR).gpr`; \\\n\telif [ `echo $(BUILD_SPEC) | cut -c1-3` = \"SIM\" ]; then \\\n\t   i586-wrs-vxworks-gnatclean -q -r -P `basename $(PRJ_ROOT_DIR).gpr`; \\\n\telse\\\n\t   gnatclean -q -r -P `basename $(PRJ_ROOT_DIR).gpr`; \\\n\tfi";
    static Document document = null;
    static Node mapAttribute;
    static ByteArrayOutputStream windriverproject;

    static {
        windriverproject = null;
    }

    public void createAdaMakefile(final IProject project, final IPath path) {
        WorkspaceJob MakefileJob = new WorkspaceJob("create ada.makefile"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    IFile makefileFragment = project.getFile(String.valueOf(path.toString()) + "/ada.makefile");
                    if (!makefileFragment.exists()) {
                        makefileFragment.create((InputStream)new ByteArrayInputStream(GNATbenchWRNatureContribution.ADA_MAKEFILE_CONTENT.getBytes()), true, null);
                    }
                    GNATbenchWRNatureContribution.updateWindriverProject(project, project.getFile(".wrproject"));
                    project.refreshLocal(2, null);
                }
                catch (Exception e) {
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        MakefileJob.schedule();
    }

    public void configure(IProject project) {
        this.createAdaMakefile(project, project.getProjectRelativePath().removeLastSegments(1));
    }

    public static void updateWindriverProject(IProject project, final IFile file) {
        String filename = file.getLocation().toOSString();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(new File(filename));
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)x);
        }
        catch (ParserConfigurationException pce) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)pce);
        }
        catch (IOException ioe) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)ioe);
        }
        if (!GNATbenchWRNatureContribution.hasGNATBuilderTool(document, false)) {
            GNATbenchWRNatureContribution.addGNATBuilderTool(document, false);
            try {
                DOMSource source = new DOMSource(document);
                windriverproject = new ByteArrayOutputStream();
                StreamResult result = new StreamResult(windriverproject);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("method", "xml");
                xformer.transform(source, result);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
            }
            catch (TransformerException transformerException) {}
        }
        WorkspaceJob ProjectUpdateJob = new WorkspaceJob("update .wrproject"){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                try {
                    file.setContents((InputStream)new ByteArrayInputStream(windriverproject.toByteArray()), true, false, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        ProjectUpdateJob.setRule((ISchedulingRule)project);
        ProjectUpdateJob.schedule();
    }

    public static boolean hasGNATBuilderTool(Node node, boolean is_tools_list) {
        boolean is_next_tools_list = false;
        if (node.hasAttributes()) {
            String key_value;
            NamedNodeMap attributes = node.getAttributes();
            if (attributes.getNamedItem("key") != null && (key_value = attributes.getNamedItem("key").getNodeValue()).equals("BLD::Info|Tools")) {
                is_next_tools_list = true;
            }
            if (is_tools_list && attributes.getNamedItem("value").getNodeValue().equals("GNAT Builder")) {
                return true;
            }
        }
        if (node.hasChildNodes()) {
            NodeList childs = node.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                boolean result = GNATbenchWRNatureContribution.hasGNATBuilderTool(childs.item(i), is_next_tools_list);
                if (result) {
                    return result;
                }
                ++i;
            }
        }
        return false;
    }

    public static void appendNode(String tool, String suffix, String value, String type) {
        String prefix = "BLD::Info|Tool|" + tool + "|";
        Element node = document.createElement(String.valueOf(type) + "Attribute");
        node.setAttribute("key", String.valueOf(prefix) + suffix);
        node.setAttribute("value", value);
        mapAttribute.appendChild(node);
    }

    public static void addGNATBuilderTool(Node node, boolean is_spec_list) {
        boolean is_next_spec_list = false;
        if (node.getNodeName().equals("mapAttribute")) {
            mapAttribute = node;
        }
        if (node.hasAttributes()) {
            NamedNodeMap attributes = node.getAttributes();
            if (attributes.getNamedItem("key") != null) {
                String key_value = attributes.getNamedItem("key").getNodeValue();
                if (key_value.equals("BLD::Info|specs")) {
                    is_next_spec_list = true;
                }
                if (key_value.equals("BLD::Info|Tools")) {
                    Element new_node = document.createElement("stringAttribute");
                    Element new_node2 = document.createElement("stringAttribute");
                    new_node.setAttribute("value", "GNAT Builder");
                    new_node2.setAttribute("value", "GNAT Linker");
                    node.appendChild(new_node);
                    node.appendChild(new_node2);
                }
            }
            if (is_spec_list) {
                String spec = attributes.getNamedItem("value").getNodeValue();
                GNATbenchWRNatureContribution.appendNode("GNAT Builder", "cmd|" + spec, "", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Builder", "dbgFlags|" + spec, "", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Builder", "derivedSigs|" + spec, "*.adaobject", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Builder", "flags|" + spec, "", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Builder", "nonDbgFlags|" + spec, "", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Builder", "object", "true", "boolean");
                GNATbenchWRNatureContribution.appendNode("GNAT Builder", "passAble", "false", "boolean");
                GNATbenchWRNatureContribution.appendNode("GNAT Builder", "sigs", "*.gpr", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Linker", "cmd|" + spec, "echo \"%Objects%\"; cp $(OBJ_DIR)/`basename $(PRJ_ROOT_DIR)`.adaobject %OutFile%", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Linker", "dbgFlags|" + spec, "", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Linker", "derivedSigs|" + spec, "*.vxe", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Linker", "flags|" + spec, "", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Linker", "nonDbgFlags|" + spec, "", "string");
                GNATbenchWRNatureContribution.appendNode("GNAT Linker", "object", "false", "boolean");
                GNATbenchWRNatureContribution.appendNode("GNAT Linker", "passAble", "false", "boolean");
                GNATbenchWRNatureContribution.appendNode("GNAT Linker", "sigs", "", "string");
            }
        }
        if (node.hasChildNodes()) {
            NodeList childs = node.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                GNATbenchWRNatureContribution.addGNATBuilderTool(childs.item(i), is_next_spec_list);
                ++i;
            }
        }
    }
}

