/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.wizards;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.GPRResourceSpy;
import com.adacore.gnatbench.core.builder.GNATbenchIncrementalBuilder;
import com.adacore.gnatbench.core.builder.GNATbenchProjectNature;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.library.Output.Output_Proc;
import com.adacore.gnatbench.library.Projects.Editor.Editor_Package;
import com.adacore.gnatbench.library.Projects.Project_Type;
import com.adacore.gnatbench.library.VFS.VFS_Package;
import com.adacore.gnatbench.library.VFS.Virtual_File;
import com.adacore.gnatbench.ui.utils.DisplayUtils;
import com.adacore.jni.AdaString;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.NewProjectAction;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

public class GNATImport
extends Wizard
implements IImportWizard {
    private String fInputGPRPath;
    private Combo fProjectChoice;
    private Button fNewProject;
    private Button fExistingProject;
    private Button fLinkMode;
    private Button fCopyMode;
    private Button useNewProjectWizard;
    private LinkedList fMarkedResources = new LinkedList();
    private static final int NOT_SET = -1;
    private static final int YES = 0;
    private static final int NO = 1;
    private static final int ALWAYS = 2;
    private static final int NEVER = 3;
    private int fOverwritePolicy = -1;
    private final boolean isWindRiverVersion = this.isWRSPluginPresent();
    private boolean requestedNewProjectWizard = false;
    private IProject projectFromWizard;

    public GNATImport() {
        this.setNeedsProgressMonitor(true);
    }

    public boolean canFinish() {
        return this.fInputGPRPath != null && !this.fInputGPRPath.equals("");
    }

    public boolean performFinish() {
        final String existingProjectName = this.fNewProject.getSelection() ? null : this.fProjectChoice.getText();
        if (this.isWindRiverVersion) {
            this.requestedNewProjectWizard = this.useNewProjectWizard.getSelection();
            if (this.requestedNewProjectWizard) {
                this.projectFromWizard = this.getNewProjectFromWizard();
                if (this.projectFromWizard == null) {
                    return false;
                }
            }
        }
        final boolean doLinkFiles = this.fLinkMode.getSelection();
        final WorkspaceModifyOperation finishOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                Iterator iter = GNATImport.this.fMarkedResources.iterator();
                while (iter.hasNext()) {
                    IResource resource = (IResource)iter.next();
                    resource.deleteMarkers("com.adacore.gnatbench.core.ImportedResourceMarker", false, 0);
                }
                GNATImport.this.fMarkedResources.clear();
            }
        };
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor monitor) throws CoreException {
                int semDepth = LibrarySemaphore.startGPSWork();
                try {
                    try {
                        GPRResourceSpy.setActivated((boolean)false);
                        GNATImport.this.importProject(existingProjectName, GNATImport.this.fInputGPRPath, doLinkFiles, monitor);
                        GPRResourceSpy.setActivated((boolean)true);
                    }
                    catch (GNATbenchCoreException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    LibrarySemaphore.stopGPSWork((int)semDepth);
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                LibrarySemaphore.stopGPSWork((int)semDepth);
                Display.getDefault().asyncExec(new Runnable(this, finishOperation){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ WorkspaceModifyOperation val$finishOperation;
                    {
                        this.this$1 = var1_1;
                        this.val$finishOperation = workspaceModifyOperation;
                    }

                    public void run() {
                        try {
                            GNATbenchCorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().run(true, true, (IRunnableWithProgress)this.val$finishOperation);
                        }
                        catch (InvocationTargetException e) {
                            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                        }
                    }
                });
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)operation);
        }
        catch (Throwable e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            DisplayUtils.displayError("GNAT Project Import Wizard", "Project importing did not complete successfully");
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)new MainPage("GNAT Project Selection"));
    }

    private LinkedList getListOfProjectsToImport(String gprProjectPath, String eclipseProjectName, boolean doLinkFile, IProgressMonitor monitor) throws CoreException, GNATbenchCoreException {
        LinkedList<ProjectToImport> result = new LinkedList<ProjectToImport>();
        monitor.beginTask("import project " + gprProjectPath, 0);
        GNATbenchKernel.getDefault().getWorkspaceProject().addDependency(gprProjectPath);
        GNATbenchKernel.getDefault().getWorkspaceProject().recompute();
        GPRProject gprProject = GPRProject.getProjectFromPath((String)gprProjectPath);
        GPRResourcesManager resourceManager = null;
        resourceManager = new GPRResourcesManager(gprProject, monitor);
        IProject project = this.requestedNewProjectWizard && this.projectFromWizard != null ? this.projectFromWizard : this.createImportedProject(gprProject, eclipseProjectName, gprProjectPath, doLinkFile, resourceManager, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
        result.add(new ProjectToImport(project, gprProject, resourceManager, null, doLinkFile));
        Project_Type[] deps = gprProject.getDependencies(true);
        int i = 0;
        while (i < deps.length - 1) {
            IProject dependencie;
            String depPath = deps[i].Project_Path(new AdaString("")).Full_Name(false).toString();
            if (!depPath.equals(gprProjectPath) && (dependencie = GPRProject.getEclipseProjectForGPRPath((String)depPath)) == null) {
                GPRProject depGprProject = GPRProject.getProjectFromPath((String)depPath);
                GPRResourcesManager depResourceManager = new GPRResourcesManager(depGprProject, monitor);
                IProject depProject = this.createImportedProject(depGprProject, null, depPath, doLinkFile, depResourceManager, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                result.add(new ProjectToImport(depProject, depGprProject, depResourceManager, project, doLinkFile));
            }
            ++i;
        }
        return result;
    }

    private void importProject(String eclipseProjectName, String gprProjectPath, boolean doLinkFile, IProgressMonitor monitor) throws CoreException, GNATbenchCoreException {
        ProjectToImport projectToImport;
        LinkedList listOfProjects = this.getListOfProjectsToImport(gprProjectPath, eclipseProjectName, doLinkFile, (IProgressMonitor)new NullProgressMonitor());
        Iterator iter = listOfProjects.iterator();
        while (iter.hasNext()) {
            ProjectToImport element = (ProjectToImport)iter.next();
            element.setup(monitor);
        }
        monitor.beginTask("import project " + gprProjectPath, listOfProjects.size() * 1000);
        iter = listOfProjects.iterator();
        while (iter.hasNext()) {
            projectToImport = (ProjectToImport)iter.next();
            this.importFilesFromProject(projectToImport, doLinkFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            GPRProject.setRootProject((IProject)projectToImport.getEclipseProject(), (boolean)false);
        }
        if (!doLinkFile) {
            iter = listOfProjects.iterator();
            while (iter.hasNext()) {
                projectToImport = (ProjectToImport)iter.next();
                projectToImport.moveGPRAndRename(projectToImport.fEclipseProject.getName());
            }
            iter = listOfProjects.iterator();
            while (iter.hasNext()) {
                projectToImport = (ProjectToImport)iter.next();
                IFile projectFile = projectToImport.getEclipseProject().getFile(String.valueOf(projectToImport.fEclipseProject.getName().toLowerCase()) + ".gpr");
                projectToImport.fGPRProject.save(projectFile);
                projectToImport.fEclipseProject.refreshLocal(1, monitor);
            }
        }
        GPRProject.setRootProject((IProject)GPRProject.getEclipseProjectForGPRName((String)(String.valueOf(GPRProject.extractNameFromPath((String)gprProjectPath)) + ".gpr")), (boolean)true);
        if (!this.isWindRiverVersion) {
            this.createGNATProMakefile(GPRProject.getEclipseProjectForGPRName((String)(String.valueOf(GPRProject.extractNameFromPath((String)gprProjectPath)) + ".gpr")), monitor);
        }
        GNATbenchKernel.getDefault().fullWorkspaceRecompute();
        monitor.done();
    }

    private IProject createImportedProject(GPRProject gprProject, String eclipseProjectName, String gprProjectPath, boolean doLinkFiles, GPRResourcesManager folderManager, IProgressMonitor monitor) throws CoreException, GNATbenchCoreException {
        IProject project = eclipseProjectName == null ? ResourcesPlugin.getWorkspace().getRoot().getProject(gprProject.getName()) : ResourcesPlugin.getWorkspace().getRoot().getProject(eclipseProjectName);
        return project;
    }

    private void importFilesFromProject(ProjectToImport project, boolean doLinkFile, IProgressMonitor monitor) throws CoreException, GNATbenchCoreException {
        monitor.beginTask("Coping directories", project.getResourceManager().getPathList().size() * 100);
        if (doLinkFile) {
            Iterator iter = project.getResourceManager().getPathList().iterator();
            while (iter.hasNext()) {
                if (!monitor.isCanceled()) {
                    PathAssociation element = (PathAssociation)iter.next();
                    try {
                        IFolder folder;
                        IPath localPath = element.getLocalPath();
                        IPath fullOSPath = element.getOSPath();
                        String folderName = localPath.getDevice() != null ? localPath.toOSString().substring(localPath.getDevice().length()) : localPath.toOSString();
                        if (folderName.length() > 0 && (folderName.charAt(folderName.length() - 1) == '/' || folderName.charAt(folderName.length() - 1) == '\\')) {
                            folderName = folderName.substring(0, folderName.length() - 1);
                        }
                        if ((folderName = String.valueOf(folderName.replaceAll("\\\\|/", " ")) + "/").equals("/")) {
                            folderName = fullOSPath.removeFirstSegments(fullOSPath.segmentCount() - 1).toString();
                        }
                        if (!this.cancelBecauseExisting((IResource)(folder = project.getEclipseProject().getFolder(folderName)), monitor)) {
                            folder.createLink(fullOSPath, 16, null);
                            folder.createMarker("com.adacore.gnatbench.core.ImportedResourceMarker");
                            this.fMarkedResources.add(folder);
                        }
                        monitor.worked(1);
                    }
                    catch (IllegalArgumentException e1) {
                        GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e1);
                    }
                    continue;
                }
                break;
            }
        } else {
            LinkedList dirs = project.fGPRProject.getSourceDirectories(false);
            PathList paths = new PathList();
            IFolder objects = project.fEclipseProject.getFolder(paths.getUniqueName("obj"));
            IFolder exec = project.fEclipseProject.getFolder(paths.getUniqueName("exec"));
            if (!objects.exists()) {
                objects.create(true, true, monitor);
            }
            if (!exec.exists()) {
                exec.create(true, true, monitor);
            }
            project.fGPRProject.setAttributeValue("Object_Dir", "", "", project.fEclipseProject.getLocation().append(objects.getProjectRelativePath()).toOSString());
            project.fGPRProject.setAttributeValue("Exec_Dir", "", "", project.fEclipseProject.getLocation().append(exec.getProjectRelativePath()).toOSString());
            String[] srcDirs = new String[dirs.size()];
            int indDir = 0;
            Iterator iterator = dirs.iterator();
            while (iterator.hasNext()) {
                String str = (String)iterator.next();
                IFolder newFolder = project.fEclipseProject.getFolder(paths.getEclipsePath(str));
                if (!newFolder.exists()) {
                    newFolder.create(true, true, monitor);
                }
                srcDirs[indDir] = project.fEclipseProject.getLocation().append(newFolder.getProjectRelativePath().lastSegment()).toOSString();
                ++indDir;
            }
            project.fGPRProject.setAttributeValue("Source_Dirs", "", "", srcDirs);
            String[] sources = project.fGPRProject.getSourcesList(false);
            int i = 0;
            while (i < sources.length) {
                Path srcPath = new Path(sources[i]);
                IPath newPath = paths.getEclipsePath(srcPath.removeLastSegments(1).removeTrailingSeparator().toOSString()).append(srcPath.lastSegment());
                IFile targetFile = project.fEclipseProject.getFile(newPath);
                if (!this.cancelBecauseExisting((IResource)targetFile, monitor)) {
                    IFile tmp = project.fEclipseProject.getFile("tmp");
                    tmp.createLink((IPath)srcPath, 16, monitor);
                    tmp.copy(newPath, true, monitor);
                    tmp.delete(true, monitor);
                }
                ++i;
            }
            project.moveGPRAndRename(String.valueOf(project.fEclipseProject.getName()) + "_tmp");
            GPRProject.setGPRPath((IProject)project.fEclipseProject, (String)(String.valueOf(project.fEclipseProject.getName().toLowerCase()) + ".gpr"));
        }
        monitor.done();
    }

    private IProject getNewProjectFromWizard() {
        NewProjectListener listener = new NewProjectListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        new NewProjectAction(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).run();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        IProject project = listener.getNewProject();
        return project;
    }

    private boolean isWRSPluginPresent() {
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("org.eclipse.ui", "newWizards");
        IExtension[] extensions = ep.getExtensions();
        if (extensions.length == 0) {
            return false;
        }
        int k = 0;
        while (k < extensions.length) {
            try {
                Bundle bundle = Platform.getBundle((String)extensions[k].getNamespace());
                if (bundle.getSymbolicName().toLowerCase().startsWith("com.windriver")) {
                    return true;
                }
            }
            catch (InvalidRegistryObjectException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                return false;
            }
            ++k;
        }
        return false;
    }

    private void createGNATProMakefile(IProject project, IProgressMonitor monitor) throws GNATbenchCoreException {
        IFile file = project.getFile((IPath)new Path("/Makefile"));
        GPRProject gprProject = GPRProject.getGPRFor((IProject)project);
        String compilerName = gprProject.getAttributeValue("compiler_command", "IDE", "ada");
        if (compilerName == null) {
            compilerName = "gnatmake";
        }
        String makeFile = GNATbenchIncrementalBuilder.makefileFromBuilder((String)compilerName);
        try {
            if (!this.cancelBecauseExisting((IResource)file, monitor)) {
                file.create((InputStream)new StringBufferInputStream(makeFile), true, null);
            }
        }
        catch (CoreException e) {
            DisplayUtils.displayError("Import GNAT Project", "Makefile creation failed");
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    private void setupImportedProject(IProject project, boolean doLinkFile, String gprProjectPath, GPRResourcesManager resourceManager) throws CoreException {
        project.createMarker("com.adacore.gnatbench.core.ImportedResourceMarker");
        this.fMarkedResources.add(project);
        if (doLinkFile) {
            GPRProject.setGPRPath((IProject)project, (String)gprProjectPath);
        } else {
            GPRProject.setGPRPath((IProject)project, (String)resourceManager.getPathForOsPath(gprProjectPath, project));
        }
        GNATbenchProjectNature.addNature((IProject)project);
    }

    private boolean cancelBecauseExisting(final IResource resource, IProgressMonitor monitor) {
        if (resource.exists()) {
            if (this.fOverwritePolicy == -1) {
                String message = resource instanceof IFile ? "The file " + ((IFile)resource).getFullPath().toOSString() : (resource instanceof IFolder ? "The folder " + ((IFolder)resource).getFullPath().toOSString() : "The resource " + resource.getName());
                final String finalMessage = message = String.valueOf(message) + " already exists on the file system. Overwrite?";
                UIJob job = new UIJob("Quering file overwrite"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        MessageDialog dialog = new MessageDialog(null, String.valueOf(resource.getName()) + " exists.", null, finalMessage, 3, new String[]{"Yes", "No", "Always", "Never"}, 1);
                        GNATImport.this.fOverwritePolicy = dialog.open();
                        return GNATbenchCorePlugin.OK_STATUS;
                    }
                };
                job.schedule();
                try {
                    job.join();
                }
                catch (InterruptedException e1) {
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e1);
                }
                switch (this.fOverwritePolicy) {
                    case 0: {
                        this.fOverwritePolicy = -1;
                    }
                    case 2: {
                        try {
                            resource.delete(true, monitor);
                        }
                        catch (CoreException e) {
                            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                        }
                        return false;
                    }
                    case 1: {
                        this.fOverwritePolicy = -1;
                    }
                    case 3: {
                        return true;
                    }
                }
            } else {
                if (this.fOverwritePolicy == 2) {
                    try {
                        resource.delete(true, monitor);
                    }
                    catch (CoreException e) {
                        GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                    }
                    return false;
                }
                if (this.fOverwritePolicy == 3) {
                    return true;
                }
            }
        }
        return false;
    }

    static /* synthetic */ void access$0(GNATImport gNATImport, String string) {
        gNATImport.fInputGPRPath = string;
    }

    private class MainPage
    extends WizardPage {
        protected MainPage(String pageName) {
            super(pageName);
            this.setTitle(pageName);
            this.setDescription("Specify the root project file for the existing GNAT project, where to put this project's content, and how to insert it.");
        }

        public void createControl(Composite parent) {
            Composite baseComp = new Composite(parent, 0);
            this.setControl((Control)baseComp);
            GridLayout topLayout = new GridLayout();
            baseComp.setLayout((Layout)topLayout);
            Composite locationComp = new Composite(baseComp, 0);
            GridLayout locationLayout = new GridLayout();
            locationLayout.numColumns = 2;
            locationLayout.marginHeight = 1;
            locationLayout.marginWidth = 1;
            locationComp.setLayout((Layout)locationLayout);
            GridData gd = new GridData(768);
            locationComp.setLayoutData((Object)gd);
            Label label = new Label(locationComp, 0);
            label.setText("Location of the root project:");
            gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
            Text projectNameWidget = new Text(locationComp, 2052);
            projectNameWidget.addModifyListener(new ModifyListener(this){
                final /* synthetic */ MainPage this$1;
                {
                    this.this$1 = mainPage;
                }

                public void modifyText(ModifyEvent e) {
                    GNATImport.access$0(MainPage.access$2(this.this$1), ((Text)e.getSource()).getText().trim());
                    if (MainPage.access$0(this.this$1)) {
                        MainPage.access$1(this.this$1).updateButtons();
                    }
                }
            });
            gd = new GridData(768);
            projectNameWidget.setLayoutData((Object)gd);
            Button button = new Button(locationComp, 8);
            button.setText("Browse");
            button.addMouseListener(new MouseListener(this, projectNameWidget){
                final /* synthetic */ MainPage this$1;
                private final /* synthetic */ Text val$projectNameWidget;
                {
                    this.this$1 = mainPage;
                    this.val$projectNameWidget = text;
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    FileDialog dialog = new FileDialog(this.this$1.getShell());
                    dialog.setFilterExtensions(new String[]{"*.gpr"});
                    String path = dialog.open();
                    if (path != null) {
                        this.val$projectNameWidget.setText(path);
                    }
                }
            });
            Composite projectComp = new Composite(baseComp, 0);
            GridLayout projectLayout = new GridLayout();
            projectLayout.numColumns = 2;
            projectLayout.marginHeight = 0;
            projectLayout.marginWidth = 0;
            projectComp.setLayout((Layout)projectLayout);
            projectComp.setLayoutData((Object)new GridData(768));
            GNATImport.this.fNewProject = new Button(projectComp, 16);
            GNATImport.this.fNewProject.setText("Import into a new project");
            GNATImport.this.fNewProject.setSelection(true);
            gd = new GridData();
            gd.horizontalSpan = 2;
            GNATImport.this.fNewProject.setLayoutData((Object)gd);
            GNATImport.this.fNewProject.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ MainPage this$1;
                {
                    this.this$1 = mainPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    GNATImport.access$3(MainPage.access$2(this.this$1)).setEnabled(false);
                    if (GNATImport.access$4(MainPage.access$2(this.this$1)) != null) {
                        GNATImport.access$4(MainPage.access$2(this.this$1)).setEnabled(true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            if (GNATImport.this.isWindRiverVersion) {
                GNATImport.this.useNewProjectWizard = new Button(projectComp, 32);
                GNATImport.this.useNewProjectWizard.setText("Configure with the New Project wizard?");
                GNATImport.this.useNewProjectWizard.setSelection(false);
                gd = new GridData();
                gd.horizontalSpan = 2;
                gd.horizontalIndent = 20;
                GNATImport.this.useNewProjectWizard.setLayoutData((Object)gd);
            }
            GNATImport.this.fExistingProject = new Button(projectComp, 16);
            GNATImport.this.fExistingProject.setText("Import into an existing project:");
            gd = new GridData();
            GNATImport.this.fExistingProject.setLayoutData((Object)gd);
            GNATImport.this.fExistingProject.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ MainPage this$1;
                {
                    this.this$1 = mainPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    GNATImport.access$3(MainPage.access$2(this.this$1)).setEnabled(true);
                    if (GNATImport.access$4(MainPage.access$2(this.this$1)) != null) {
                        GNATImport.access$4(MainPage.access$2(this.this$1)).setEnabled(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            GNATImport.this.fProjectChoice = new Combo(projectComp, 4);
            GNATImport.this.fProjectChoice.setEnabled(false);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                GNATImport.this.fProjectChoice.add(projects[i].getName());
                ++i;
            }
            gd = new GridData(768);
            GNATImport.this.fProjectChoice.setLayoutData((Object)gd);
            Composite copyComp = new Composite(baseComp, 0);
            GridLayout copyLayout = new GridLayout();
            copyLayout.numColumns = 1;
            copyLayout.marginHeight = 0;
            copyLayout.marginWidth = 0;
            copyComp.setLayout((Layout)copyLayout);
            copyComp.setLayoutData((Object)new GridData(768));
            GNATImport.this.fLinkMode = new Button(copyComp, 16);
            GNATImport.this.fLinkMode.setText("Link project files into workspace");
            GNATImport.this.fLinkMode.setSelection(true);
            gd = new GridData();
            GNATImport.this.fLinkMode.setLayoutData((Object)gd);
            GNATImport.this.fCopyMode = new Button(copyComp, 16);
            GNATImport.this.fCopyMode.setText("Copy project files into workspace");
            GNATImport.this.fCopyMode.setSelection(false);
            gd = new GridData();
            GNATImport.this.fCopyMode.setLayoutData((Object)gd);
        }

        static /* synthetic */ boolean access$0(MainPage mainPage) {
            return mainPage.isCurrentPage();
        }

        static /* synthetic */ IWizardContainer access$1(MainPage mainPage) {
            return mainPage.getContainer();
        }

        static /* synthetic */ GNATImport access$2(MainPage mainPage) {
            return mainPage.GNATImport.this;
        }
    }

    private class PathAssociation {
        private IPath fOsPath;
        private IPath fLocalPath;

        public PathAssociation(IPath osPath, IPath localPath) {
            this.fOsPath = osPath;
            this.fLocalPath = localPath;
        }

        public IPath getLocalPath() {
            return this.fLocalPath;
        }

        public IPath getOSPath() {
            return this.fOsPath;
        }
    }

    private class GPRResourcesManager {
        private LinkedList fPathList = new LinkedList();
        Project_Type[] fDependencies;

        public GPRResourcesManager(GPRProject gprProject, IProgressMonitor monitor) throws GNATbenchCoreException {
            String element;
            LinkedList directories = gprProject.getSourceDirectories(false);
            directories.addAll(gprProject.getObjectDirectories(false));
            int minCommonFolders = -1;
            Path basePath = new Path((String)directories.get(0));
            Iterator iter = directories.iterator();
            while (iter.hasNext()) {
                element = (String)iter.next();
                Path fullOSPath = new Path(element);
                int nbCommonFolders = basePath.matchingFirstSegments((IPath)fullOSPath);
                if (nbCommonFolders >= minCommonFolders && minCommonFolders != -1) continue;
                minCommonFolders = nbCommonFolders;
            }
            iter = directories.iterator();
            while (iter.hasNext()) {
                element = (String)iter.next();
                IPath newPath = new Path(element).removeFirstSegments(minCommonFolders);
                boolean addPath = true;
                LinkedList<PathAssociation> elementsToRemove = new LinkedList<PathAssociation>();
                Iterator iter2 = this.fPathList.iterator();
                while (iter2.hasNext()) {
                    PathAssociation path = (PathAssociation)iter2.next();
                    int common = newPath.matchingFirstSegments(path.getLocalPath());
                    if (common == path.getLocalPath().segmentCount()) {
                        addPath = false;
                        break;
                    }
                    if (common != newPath.segmentCount()) continue;
                    elementsToRemove.add(path);
                }
                if (addPath) {
                    this.fPathList.add(new PathAssociation((IPath)new Path(element.replaceAll("\\\\", "/").replaceAll("/$", "")), newPath));
                }
                this.fPathList.removeAll(elementsToRemove);
            }
            this.fDependencies = gprProject.getDependencies(false);
        }

        public LinkedList getPathList() {
            return this.fPathList;
        }

        public String getPathForOsPath(String strPath, IProject project) {
            Path path = new Path(strPath);
            String fileName = path.lastSegment();
            String folderPath = path.removeLastSegments(1).toString();
            Iterator iter = this.fPathList.iterator();
            while (iter.hasNext()) {
                PathAssociation element = (PathAssociation)iter.next();
                if (!element.getOSPath().toOSString().equals(folderPath)) continue;
                IPath localPath = element.getLocalPath().setDevice("");
                return String.valueOf(project.getLocation().toOSString()) + localPath.toString() + fileName;
            }
            return path.lastSegment();
        }

        public Project_Type[] getDependencies() {
            return this.fDependencies;
        }
    }

    private class ProjectToImport {
        private IProject fEclipseProject;
        private IProject fParentProject;
        private boolean fDoLinkFiles;
        private GPRProject fGPRProject;
        private GPRResourcesManager fFolderManager;

        public ProjectToImport(IProject eclipseProject, GPRProject gprProject, GPRResourcesManager folderManager, IProject parentProject, boolean doLinkFiles) {
            this.fEclipseProject = eclipseProject;
            this.fParentProject = parentProject;
            this.fDoLinkFiles = doLinkFiles;
            this.fGPRProject = gprProject;
            this.fFolderManager = folderManager;
        }

        public IProject getEclipseProject() {
            return this.fEclipseProject;
        }

        public GPRProject getGPRProject() {
            return this.fGPRProject;
        }

        public GPRResourcesManager getResourceManager() {
            return this.fFolderManager;
        }

        public void moveGPRAndRename(String newName) throws GNATbenchCoreException {
            IPath gprPath = this.fEclipseProject.getLocation();
            Editor_Package.Rename_And_Move((Project_Type)GNATbenchKernel.getDefault().getWorkspaceProject().getGPRProject(), (Project_Type)this.fGPRProject.getGPRProject(), (AdaString)new AdaString(newName), (Virtual_File)VFS_Package.Create((AdaString)new AdaString(gprPath.toOSString())), (Output_Proc)new Output_Proc(this){
                final /* synthetic */ ProjectToImport this$1;
                {
                    this.this$1 = projectToImport;
                }

                public void Output_Proc_Body(AdaString S) {
                    GNATbenchCorePlugin.getDefault().logError("Error when Importing: " + S.toString(), null);
                }
            });
        }

        public void setup(IProgressMonitor monitor) throws CoreException, GNATbenchCoreException {
            if (!this.fEclipseProject.exists()) {
                this.fEclipseProject.create((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            }
            this.fEclipseProject.open((IProgressMonitor)new SubProgressMonitor(monitor, 0));
            GNATImport.this.setupImportedProject(this.fEclipseProject, this.fDoLinkFiles, this.fGPRProject.getGPRProject().Project_Path(new AdaString("")).Full_Name(false).toString(), this.fFolderManager);
            if (this.fParentProject != null) {
                IProjectDescription description = this.fParentProject.getDescription();
                IProject[] references = description.getReferencedProjects();
                boolean found = false;
                int j = 0;
                while (j < references.length) {
                    if (references[j].equals((Object)this.fEclipseProject)) {
                        found = true;
                    }
                    ++j;
                }
                if (!found) {
                    IProject[] tmpReferences = new IProject[references.length + 1];
                    System.arraycopy(references, 0, tmpReferences, 0, references.length);
                    tmpReferences[tmpReferences.length - 1] = this.fEclipseProject;
                    description.setReferencedProjects(tmpReferences);
                    this.fParentProject.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
    }

    private class PathList {
        private LinkedList fPathList = new LinkedList();
        private LinkedList fNameList = new LinkedList();

        private PathList() {
        }

        public IPath getEclipsePath(String osPath) {
            IPath path = new Path(osPath).removeTrailingSeparator();
            Iterator iter = this.fPathList.iterator();
            while (iter.hasNext()) {
                PathAssociation element = (PathAssociation)iter.next();
                if (!element.fOsPath.equals((Object)path)) continue;
                return element.getLocalPath();
            }
            String newName = this.getUniqueName(path.lastSegment());
            Path newPath = new Path(newName);
            this.fPathList.add(new PathAssociation(path, (IPath)newPath));
            return newPath;
        }

        public String getUniqueName(String name) {
            String newName = name;
            int duplicateIndex = 1;
            Iterator iter = this.fNameList.iterator();
            while (iter.hasNext()) {
                String oldName = (String)iter.next();
                if (!oldName.equals(newName)) continue;
                newName = String.valueOf(name) + " (" + duplicateIndex + ")";
            }
            this.fNameList.add(newName);
            return newName;
        }
    }

    class NewProjectListener
    implements IResourceChangeListener {
        private IProject newProject = null;

        NewProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta root = event.getDelta();
            IResourceDelta[] projectDeltas = root.getAffectedChildren();
            int i = 0;
            while (i < projectDeltas.length) {
                IResourceDelta delta = projectDeltas[i];
                IResource resource = delta.getResource();
                if (delta.getKind() == 1) {
                    this.newProject = (IProject)resource;
                }
                ++i;
            }
        }

        public IProject getNewProject() {
            return this.newProject;
        }
    }
}

