/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.projectexplorer;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.library.Projects.Project_Type;
import com.adacore.gnatbench.ui.projectexplorer.SourceDirectoryNode;
import com.adacore.gnatbench.ui.projectexplorer.SourceFileNode;
import com.adacore.gnatbench.ui.projectexplorer.TreeObject;
import com.adacore.gnatbench.ui.projectexplorer.TreeParent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ProjectNode
extends TreeParent
implements IAdaptable {
    private GPRProject project;
    private boolean isRoot = false;
    private boolean computed = false;
    private boolean closed = false;
    static /* synthetic */ Class class$0;

    public ProjectNode(Project_Type project) throws GNATbenchCoreException {
        this.project = new GPRProject(project, "");
        super.setName(this.project.getName());
    }

    public ProjectNode() throws GNATbenchCoreException {
        this.isRoot = true;
        this.project = GPRProject.getRoot();
        super.setName(this.project.getName());
    }

    private LinkedList dependencies() throws GNATbenchCoreException {
        LinkedList<ProjectNode> result = new LinkedList<ProjectNode>();
        Project_Type[] list = this.project.getDependencies(false);
        int j = 0;
        while (j < list.length) {
            result.add(new ProjectNode(list[j]));
            ++j;
        }
        return result;
    }

    public boolean hasChildren() {
        if (this.closed) {
            return false;
        }
        return this.computed ? super.hasChildren() : true;
    }

    private void insertSources(LinkedList sourceDirectories) throws GNATbenchCoreException {
        LinkedList<SourceDirectoryNode> sourceDirNodes = new LinkedList<SourceDirectoryNode>();
        Iterator iter = sourceDirectories.iterator();
        while (iter.hasNext()) {
            int segs;
            Path path = new Path((String)iter.next());
            IPath label = path.removeFirstSegments(segs = path.matchingFirstSegments((IPath)new Path(this.project.getFile().getPath()))).setDevice(null);
            SourceDirectoryNode node = label.toString().equals("") ? new SourceDirectoryNode(path, ".") : new SourceDirectoryNode(path, label.toString());
            sourceDirNodes.add(node);
            this.addChild(node);
        }
        String[] sourceFiles = this.project.getSourcesList(false);
        Arrays.sort(sourceFiles, null);
        SourceDirectoryNode currentDirectoryNode = (SourceDirectoryNode)sourceDirNodes.getFirst();
        int k = 0;
        while (k < sourceFiles.length) {
            SourceFileNode file = new SourceFileNode(sourceFiles[k]);
            if (!file.getDir().equals((Object)currentDirectoryNode.getDir())) {
                Iterator iter2 = sourceDirNodes.iterator();
                while (iter2.hasNext()) {
                    currentDirectoryNode = (SourceDirectoryNode)iter2.next();
                    if (file.getDir().equals((Object)currentDirectoryNode.getDir())) break;
                }
            }
            currentDirectoryNode.addChild(file);
            ++k;
        }
    }

    public Image image() {
        if (this.closed) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
    }

    public boolean needsCompute() {
        return !this.computed;
    }

    public void costlyCompute() {
        if (this.computed) {
            return;
        }
        this.computed = true;
        try {
            LinkedList sourceDirectories;
            if (!this.isRoot && !(sourceDirectories = this.project.getSourceDirectories(false)).isEmpty()) {
                this.insertSources(sourceDirectories);
            }
            LinkedList subs = this.dependencies();
            Iterator iter = subs.iterator();
            while (iter.hasNext()) {
                this.addChild((ProjectNode)iter.next());
            }
        }
        catch (GNATbenchCoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    public GPRProject getProject() {
        return this.project;
    }

    public Object getAdapter(Class adapter) {
        Object ret = super.getAdapter(adapter);
        if (ret != null) {
            return ret;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.isAssignableFrom(clazz)) {
            try {
                ret = GPRProject.getEclipseProjectForGPRName((String)this.project.getName());
            }
            catch (GNATbenchCoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                return null;
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                return null;
            }
            return ret;
        }
        return null;
    }

    public void refresh() {
        Object[] child = this.children.toArray();
        this.computed = false;
        int j = 0;
        while (j < child.length) {
            this.removeChild((TreeObject)child[j]);
            ++j;
        }
    }

    public void refresh(IProject project) {
        if (this.project.getProject().equals((Object)project)) {
            this.refresh();
        } else {
            Object[] child = this.children.toArray();
            int j = 0;
            while (j < child.length) {
                if (child[j] instanceof ProjectNode) {
                    ((ProjectNode)child[j]).refresh(project);
                }
                ++j;
            }
        }
    }

    public void close() {
        this.closed = true;
        this.refresh();
    }

    public void open() {
        this.closed = false;
        this.refresh();
    }
}

