/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.projectexplorer;

import com.adacore.gnatbench.core.GNATbenchCoreException;
import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.GNATbenchKernel;
import com.adacore.gnatbench.core.IGPRListener;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.projectexplorer.ProjectNode;
import com.adacore.gnatbench.ui.projectexplorer.SourceDirectoryNode;
import com.adacore.gnatbench.ui.projectexplorer.SourceFileNode;
import com.adacore.gnatbench.ui.projectexplorer.TreeObject;
import com.adacore.gnatbench.ui.projectexplorer.TreeParent;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.progress.UIJob;

public class ProjectExplorerContentProvider
implements IStructuredContentProvider,
ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor,
IGPRListener {
    private TreeViewer viewer;
    protected static final Object[] NO_CHILDREN = new Object[0];
    private ProjectNode invisibleRoot;
    private IViewSite site;

    public ProjectExplorerContentProvider(IViewSite site, TreeViewer viewer) {
        this.site = site;
        this.viewer = viewer;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        GNATbenchKernel.getDefault().addGPRListener((IGPRListener)this);
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
        GNATbenchKernel.getDefault().removeGPSListener((IGPRListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.site)) {
            if (this.invisibleRoot == null) {
                this.initialize();
            }
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof TreeObject) {
            return ((TreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TreeParent) {
            final TreeParent theParent = (TreeParent)parent;
            if (theParent.needsCompute()) {
                new Job("Analyze children"){

                    protected IStatus run(IProgressMonitor monitor) {
                        theParent.costlyCompute();
                        new UIJob(this, "Update viewer"){
                            final /* synthetic */ 1 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                ProjectExplorerContentProvider.access$0(1.access$0(this.this$1)).refresh();
                                return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
                            }
                        }.schedule();
                        return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
                    }

                    static /* synthetic */ ProjectExplorerContentProvider access$0(1 var0) {
                        return var0.ProjectExplorerContentProvider.this;
                    }
                }.schedule();
                TreeObject t = new TreeObject();
                t.setName("...");
                return new Object[]{t};
            }
            return ((TreeParent)parent).getChildren();
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).hasChildren();
        }
        return false;
    }

    private void initialize() {
        try {
            this.invisibleRoot = new ProjectNode();
        }
        catch (GNATbenchCoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    private void UIrefresh(final TreeObject node) {
        new UIJob("Update viewer"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (node == ProjectExplorerContentProvider.this.invisibleRoot) {
                    ProjectExplorerContentProvider.this.viewer.refresh();
                } else {
                    ProjectExplorerContentProvider.this.viewer.refresh((Object)node);
                }
                return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
            }
        }.schedule();
    }

    private boolean explore(TreeParent node, TreeParent parent, IResourceDelta delta, IResource resource) {
        int kind = delta.getKind();
        int type = resource.getType();
        if (type == 8) {
            return false;
        }
        block0 : switch (type) {
            case 1: {
                switch (kind) {
                    case 2: {
                        if (!(node instanceof SourceFileNode) || !((SourceFileNode)node).getFullPath().equals((Object)resource.getLocation())) break block0;
                        parent.removeChild(node);
                        this.UIrefresh(parent);
                        return true;
                    }
                    case 1: {
                        if (!(node instanceof SourceDirectoryNode) || !((SourceDirectoryNode)node).getDir().equals((Object)resource.getLocation().removeLastSegments(1))) break block0;
                        SourceFileNode file = new SourceFileNode(resource.getLocation().toString());
                        node.addChild(file);
                        this.UIrefresh(parent);
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                if (node instanceof SourceDirectoryNode) {
                    return false;
                }
                switch (kind) {
                    case 1: 
                    case 2: 
                    case 4: {
                        return true;
                    }
                }
                return false;
            }
        }
        TreeObject[] child = node.getChildren();
        int j = 0;
        while (j < child.length) {
            if (this.explore((TreeParent)child[j], node, delta, resource)) {
                return false;
            }
            ++j;
        }
        return false;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource != null) {
            this.explore(this.invisibleRoot, null, delta, resource);
        }
        return true;
    }

    public void workspaceRecomputed() {
        try {
            this.invisibleRoot = new ProjectNode();
            this.UIrefresh(this.invisibleRoot);
        }
        catch (GNATbenchCoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }
}

