/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.projectexplorer;

import com.adacore.gnatbench.ui.projectexplorer.ProjectExplorerContentProvider;
import com.adacore.gnatbench.ui.projectexplorer.TreeObject;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;
import org.eclipse.ui.actions.NewWizardMenu;
import org.eclipse.ui.actions.RefreshAction;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class ProjectExplorer
extends ViewPart
implements ISetSelectionTarget,
Preferences.IPropertyChangeListener {
    private TreeViewer viewer;
    private ProjectExplorerContentProvider provider;
    private DrillDownAdapter drillDownAdapter;
    private Action doubleClickAction;
    private RefreshAction refreshAction;
    private ImportResourcesAction importAction;
    private ExportResourcesAction exportAction;
    private NewWizardMenu newWizardMenu;

    public TreeViewer GetViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        Shell shell = this.getViewSite().getShell();
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.provider = new ProjectExplorerContentProvider(this.getViewSite(), this.viewer);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.refresh();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.hookOpenAction();
        this.contributeToActionBars();
        this.importAction = new ImportResourcesAction(this.getViewSite().getWorkbenchWindow());
        this.exportAction = new ExportResourcesAction(this.getViewSite().getWorkbenchWindow());
        this.refreshAction = new RefreshAction(shell);
        this.newWizardMenu = new NewWizardMenu(this.getViewSite().getWorkbenchWindow());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ProjectExplorer.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    void fillContextMenu(IMenuManager manager) {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        MenuManager newMenu = new MenuManager("New...");
        manager.add((IContributionItem)newMenu);
        newMenu.add((IContributionItem)this.newWizardMenu);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importAction);
        manager.add((IAction)this.exportAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
        this.refreshAction.selectionChanged(sel);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = ProjectExplorer.this.viewer.getSelection();
                TreeObject obj = (TreeObject)((IStructuredSelection)selection).getFirstElement();
                obj.onDoubleClick();
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectExplorer.this.doubleClickAction.run();
            }
        });
    }

    private void hookOpenAction() {
        this.viewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void selectReveal(ISelection selection) {
        this.viewer.setSelection(selection, true);
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof TreeObject) {
                return ((TreeObject)obj).image();
            }
            return null;
        }
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

