/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.launching;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AdaDebugTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        this.setTabs(new ILaunchConfigurationTab[]{new MainTab()});
    }

    public class MainTab
    extends AbstractLaunchConfigurationTab {
        private Text fExecNameWidget;
        private Combo fPrjNameWidget;
        private ILaunchConfigurationWorkingCopy fConfiguration;

        public void createControl(Composite parent) {
            Composite baseComp = new Composite(parent, 0);
            this.setControl((Control)baseComp);
            GridLayout topLayout = new GridLayout();
            baseComp.setLayout((Layout)topLayout);
            Composite locationComp = new Composite(baseComp, 0);
            GridLayout locationLayout = new GridLayout();
            locationLayout.numColumns = 2;
            locationLayout.marginHeight = 0;
            locationLayout.marginWidth = 0;
            locationComp.setLayout((Layout)locationLayout);
            GridData gd = new GridData(768);
            locationComp.setLayoutData((Object)gd);
            Label prjLabel = new Label(locationComp, 0);
            prjLabel.setText("Project:");
            gd = new GridData();
            gd.horizontalSpan = 2;
            prjLabel.setLayoutData((Object)gd);
            Combo prjList = this.fPrjNameWidget = new Combo(locationComp, 2052);
            gd = new GridData(768);
            prjList.setLayoutData((Object)gd);
            IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int j = 0;
            while (j < projects.length) {
                GPRProject gprProject = GPRProject.getGPRFor((IProject)projects[j]);
                if (gprProject != null) {
                    prjList.add(projects[j].getName());
                }
                ++j;
            }
            prjList.addModifyListener(new ModifyListener(this, prjList){
                final /* synthetic */ MainTab this$1;
                private final /* synthetic */ Combo val$prjList;
                {
                    this.this$1 = mainTab;
                    this.val$prjList = combo;
                }

                public void modifyText(ModifyEvent e) {
                    if (MainTab.access$0(this.this$1) != null) {
                        MainTab.access$0(this.this$1).setAttribute("project_name", this.val$prjList.getText());
                        MainTab.access$1(this.this$1).updateButtons();
                    }
                }
            });
            Label execLabel = new Label(locationComp, 0);
            execLabel.setText("Location of the executable:");
            gd = new GridData();
            gd.horizontalSpan = 2;
            execLabel.setLayoutData((Object)gd);
            Text execText = this.fExecNameWidget = new Text(locationComp, 2052);
            gd = new GridData(768);
            execText.setLayoutData((Object)gd);
            execText.addModifyListener(new ModifyListener(this, execText){
                final /* synthetic */ MainTab this$1;
                private final /* synthetic */ Text val$execText;
                {
                    this.this$1 = mainTab;
                    this.val$execText = text;
                }

                public void modifyText(ModifyEvent e) {
                    if (MainTab.access$0(this.this$1) != null) {
                        MainTab.access$0(this.this$1).setAttribute("file_name", this.val$execText.getText());
                        MainTab.access$1(this.this$1).updateButtons();
                    }
                }
            });
            Button execButton = this.createPushButton(locationComp, "Browse", null);
            execButton.addMouseListener(new MouseListener(this, execText){
                final /* synthetic */ MainTab this$1;
                private final /* synthetic */ Text val$execText;
                {
                    this.this$1 = mainTab;
                    this.val$execText = text;
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    String path = new FileDialog(MainTab.access$2(this.this$1)).open();
                    if (path != null) {
                        this.val$execText.setText(path);
                    }
                }
            });
        }

        public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        }

        public void initializeFrom(ILaunchConfiguration configuration) {
            try {
                this.fExecNameWidget.setText(configuration.getAttribute("file_name", ""));
                this.fPrjNameWidget.setText(configuration.getAttribute("project_name", ""));
            }
            catch (CoreException e) {
                GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
            }
        }

        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            this.fConfiguration = configuration;
        }

        public String getName() {
            return "Main Ada program";
        }

        public boolean isValid(ILaunchConfiguration config) {
            return true;
        }

        public boolean canSave() {
            return true;
        }

        static /* synthetic */ ILaunchConfigurationWorkingCopy access$0(MainTab mainTab) {
            return mainTab.fConfiguration;
        }

        static /* synthetic */ ILaunchConfigurationDialog access$1(MainTab mainTab) {
            return mainTab.getLaunchConfigurationDialog();
        }

        static /* synthetic */ Shell access$2(MainTab mainTab) {
            return mainTab.getShell();
        }
    }
}

