/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.jobs;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.toolchain.ToolChain;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import com.adacore.gnatbench.ui.utils.DisplayUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class GNATstubJob
extends WorkspaceJob {
    String specFileName;
    String bodyFileName;
    String workingDirName;
    IProject project;

    public GNATstubJob(String workingDir, String specFileName, String bodyFileName, IProject project) {
        super("Ada Body Generation");
        this.specFileName = specFileName;
        this.bodyFileName = bodyFileName;
        this.workingDirName = workingDir;
        this.project = project;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        String toolNamePrefix;
        String projectFileName = this.project.getLocation() + "/" + this.project.getName() + ".gpr";
        if (System.getProperty("os.name").startsWith("Windows")) {
            projectFileName = "\"" + projectFileName + "\"";
            this.specFileName = "\"" + this.specFileName + "\"";
            this.bodyFileName = "\"" + this.bodyFileName + "\"";
        }
        String command = "gnat stub -f -q -P " + projectFileName + " " + this.specFileName + " -o " + this.bodyFileName;
        try {
            String compilerCommand = ToolChain.active().name(this.project);
            int lastDash = compilerCommand.lastIndexOf("-");
            toolNamePrefix = lastDash != -1 ? compilerCommand.substring(0, lastDash) : "";
        }
        catch (ToolChain.NoExtensionFound noExtensionFound) {
            return new Status(4, GNATbenchUIPlugin.getId(), 0, "GNATstubJob failed because no toolchain definition was found", null);
        }
        if (!toolNamePrefix.equals("")) {
            command = String.valueOf(toolNamePrefix) + "-" + command;
        }
        File workingDir = new File(this.workingDirName);
        try {
            int exitVal;
            Process proc = Runtime.getRuntime().exec(command, null, workingDir);
            InputStream stderr = proc.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            String message = null;
            while ((line = br.readLine()) != null) {
                message = message == null ? line : String.valueOf(message) + "\n" + line;
            }
            if (message != null) {
                DisplayUtils.displayError("Package Body Stub Generation", message);
            }
            if ((exitVal = proc.waitFor()) != 0 && message == null) {
                return new Status(4, GNATbenchUIPlugin.getId(), 0, "GNATstubJob failed with error code " + exitVal, null);
            }
        }
        catch (Throwable e) {
            GNATbenchCorePlugin.getDefault().logError(null, e);
            return new Status(4, GNATbenchUIPlugin.getId(), 0, "GNATstubJob failed due to an exception", null);
        }
        return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
    }
}

