/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.gpreditor;

import com.adacore.gnatbench.core.adaeditor.AdaCharacterRule;
import com.adacore.gnatbench.core.adaeditor.AdaStringRule;
import com.adacore.gnatbench.core.adaeditor.AdaWordDetector;
import com.adacore.gnatbench.ui.gpreditor.ColorManager;
import com.adacore.gnatbench.ui.gpreditor.GPRWhitespaceDetector;
import com.adacore.gnatbench.ui.gpreditor.IGPRColorConstants;
import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class GPRScanner
extends RuleBasedScanner {
    public GPRScanner(ColorManager manager) {
        Token comment = new Token((Object)new TextAttribute(manager.getColor(IGPRColorConstants.COMMENT)));
        Token string = new Token((Object)new TextAttribute(manager.getColor(IGPRColorConstants.STRING)));
        Token keyword = new Token((Object)new TextAttribute(manager.getColor(IGPRColorConstants.RESERVED_WORD)));
        Token packageWords = new Token((Object)new TextAttribute(manager.getColor(IGPRColorConstants.PACKAGES)));
        Token attrWords = new Token((Object)new TextAttribute(manager.getColor(IGPRColorConstants.ATTRIBUTES)));
        Token userWords = new Token((Object)new TextAttribute(manager.getColor(IGPRColorConstants.USER_DEFINED)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("--", (IToken)comment));
        rules.add(new AdaCharacterRule((IToken)string));
        rules.add(new AdaStringRule((IToken)string));
        WordRule word = new WordRule((IWordDetector)new AdaWordDetector(), (IToken)userWords);
        word.addWord("package", (IToken)keyword);
        word.addWord("project", (IToken)keyword);
        word.addWord("case", (IToken)keyword);
        word.addWord("when", (IToken)keyword);
        word.addWord("is", (IToken)keyword);
        word.addWord("for", (IToken)keyword);
        word.addWord("type", (IToken)keyword);
        word.addWord("use", (IToken)keyword);
        word.addWord("end", (IToken)keyword);
        word.addWord("extends", (IToken)keyword);
        word.addWord("renames", (IToken)keyword);
        word.addWord("others", (IToken)keyword);
        word.addWord("with", (IToken)keyword);
        word.addWord("null", (IToken)keyword);
        word.addWord("external", (IToken)keyword);
        word.addWord("Compiler", (IToken)packageWords);
        word.addWord("Builder", (IToken)packageWords);
        word.addWord("Linker", (IToken)packageWords);
        word.addWord("IDE", (IToken)packageWords);
        word.addWord("Naming", (IToken)packageWords);
        word.addWord("Finder", (IToken)packageWords);
        word.addWord("Cross_Reference", (IToken)packageWords);
        word.addWord("Eliminate", (IToken)packageWords);
        word.addWord("Pretty_Printer", (IToken)packageWords);
        word.addWord("Metrics", (IToken)packageWords);
        word.addWord("gnatls", (IToken)packageWords);
        word.addWord("gnatstub", (IToken)packageWords);
        word.addWord("Language_Processing", (IToken)packageWords);
        word.addWord("Main", (IToken)attrWords);
        word.addWord("Exec_Dir", (IToken)attrWords);
        word.addWord("Object_Dir", (IToken)attrWords);
        word.addWord("Source_Dirs", (IToken)attrWords);
        word.addWord("Default_Switches", (IToken)attrWords);
        word.addWord("Switches", (IToken)attrWords);
        word.addWord("Source_Files", (IToken)attrWords);
        word.addWord("Source_List_File", (IToken)attrWords);
        word.addWord("Locally_Removed_Files", (IToken)attrWords);
        word.addWord("Languages", (IToken)attrWords);
        word.addWord("Library_Dir", (IToken)attrWords);
        word.addWord("Library_Name", (IToken)attrWords);
        word.addWord("Library_Kind", (IToken)attrWords);
        word.addWord("Library_Version", (IToken)attrWords);
        word.addWord("Library_Interface", (IToken)attrWords);
        word.addWord("Library_Auto_Init", (IToken)attrWords);
        word.addWord("Library_Options", (IToken)attrWords);
        word.addWord("Library_Src_Dir", (IToken)attrWords);
        word.addWord("Library_ALI_Dir", (IToken)attrWords);
        word.addWord("Library_GCC", (IToken)attrWords);
        word.addWord("Library_Symbol_File", (IToken)attrWords);
        word.addWord("Library_Symbol_Policy", (IToken)attrWords);
        word.addWord("Library_Reference_Symbol_File", (IToken)attrWords);
        word.addWord("Externally_Built", (IToken)attrWords);
        word.addWord("Spec_Suffix", (IToken)attrWords);
        word.addWord("Body_Suffix", (IToken)attrWords);
        word.addWord("Specification_Suffix", (IToken)attrWords);
        word.addWord("Implementation_Suffix", (IToken)attrWords);
        word.addWord("Executable_Suffix", (IToken)attrWords);
        word.addWord("Separate_Suffix", (IToken)attrWords);
        word.addWord("Casing", (IToken)attrWords);
        word.addWord("Dot_Replacement", (IToken)attrWords);
        word.addWord("Spec", (IToken)attrWords);
        word.addWord("Body", (IToken)attrWords);
        word.addWord("Specification_Exceptions", (IToken)attrWords);
        word.addWord("Implementation_Exceptions", (IToken)attrWords);
        word.addWord("Compiler_Command", (IToken)attrWords);
        word.addWord("Gnatlist", (IToken)attrWords);
        word.addWord("Debugger_Command", (IToken)attrWords);
        word.addWord("Remote_Host", (IToken)attrWords);
        word.addWord("Program_Host", (IToken)attrWords);
        word.addWord("Communication_Protocol", (IToken)attrWords);
        rules.add(word);
        rules.add(new WhitespaceRule((IWhitespaceDetector)new GPRWhitespaceDetector()));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

