/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.gpreditor;

import com.adacore.gnatbench.ui.gpreditor.ColorManager;
import com.adacore.gnatbench.ui.gpreditor.GPRScanner;
import com.adacore.gnatbench.ui.gpreditor.IGPRColorConstants;
import com.adacore.gnatbench.ui.gpreditor.NonRuleBasedDamagerRepairer;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class GPRConfiguration
extends SourceViewerConfiguration {
    private DefaultTextDoubleClickStrategy doubleClickStrategy;
    private GPRScanner scanner;
    private ColorManager colorManager;

    public GPRConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__gpr_comment"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new DefaultTextDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected GPRScanner getGPRScanner() {
        if (this.scanner == null) {
            this.scanner = new GPRScanner(this.colorManager);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(IGPRColorConstants.DEFAULT))));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getGPRScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor(IGPRColorConstants.COMMENT)));
        reconciler.setDamager((IPresentationDamager)ndr, "__gpr_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__gpr_comment");
        return reconciler;
    }
}

