/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.compiler;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.core.analyzer.AdaEntityReference;
import com.adacore.gnatbench.core.analyzer.AdaFile;
import com.adacore.gnatbench.core.analyzer.AdaLocation;
import com.adacore.gnatbench.core.gpswrappers.File;
import com.adacore.gnatbench.ui.adaeditor.AdaEditor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class CompilerMessage {
    private AdaLocation fLocation;
    private IMarker fMarker;

    public CompilerMessage(IProject project, String message, int number) {
        int column;
        int line;
        String fileName;
        String[] parts = message.split(":");
        if (parts.length < 4) {
            return;
        }
        try {
            fileName = parts[0];
            line = Integer.parseInt(parts[1]);
            column = Integer.parseInt(parts[2]);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        String caption = "";
        String col = "";
        int i = 3;
        while (i < parts.length) {
            caption = String.valueOf(caption) + col + parts[i];
            col = ":";
            ++i;
        }
        File file = null;
        file = File.fromGPSName((IProject)project, (String)fileName);
        this.fLocation = AdaLocation.fromGPS((AdaFile)AdaFile.fromOSPath((IProject)project, (String)file.getPath()), (int)line, (int)column);
        IFile resource = this.fLocation.getAdaFile().getFile();
        if (resource == null) {
            return;
        }
        try {
            AdaDocumentBuffer buffer = GNATbenchCorePlugin.getDefault().getDocumentBuffer(this.fLocation);
            AdaEntityReference entity = buffer.getEntity(this.fLocation);
            this.fMarker = resource.createMarker("com.adacore.gnatbench.core.AdaErrorMarker");
            this.fMarker.setAttribute("charStart", entity.getOffset());
            this.fMarker.setAttribute("charEnd", entity.getOffset() + entity.getName().length());
            this.fMarker.setAttribute("lineNumber", entity.getLocation().getEclipseLine());
            this.fMarker.setAttribute("AdaLocationMarker.Column", entity.getLocation().getEclipseColumn());
            this.fMarker.setAttribute("AdaLocationMarker.Text", (Object)entity.getName());
            if (caption.substring(1, 8).equals("warning") || caption.substring(1, 8).equals("(style)")) {
                this.fMarker.setAttribute("severity", 1);
            } else {
                this.fMarker.setAttribute("severity", 2);
            }
            this.fMarker.setAttribute("message", (Object)caption);
            this.fMarker.setAttribute("AdaErrorMarker.Number", number);
            AdaEditor editor = (AdaEditor)GNATbenchCorePlugin.getDefault().getEditor(this.fLocation);
            if (editor != null) {
                editor.updateAnnotations();
            }
        }
        catch (CoreException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }
}

