/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.compiler;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.builder.GNATbenchBuilderJob;
import com.adacore.gnatbench.core.gpswrappers.GPRProject;
import com.adacore.gnatbench.core.toolchain.ToolChain;
import com.adacore.gnatbench.ui.GNATbenchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class CompileAdaFilesJob
extends Job {
    private Object[] validResources = null;

    public CompileAdaFilesJob(Object[] resources) {
        super("Ada File(s) Compilation");
        int length = 0;
        int k = 0;
        while (k < resources.length) {
            IResource element = (IResource)resources[k];
            if (element != null) {
                GNATbenchUIPlugin.getDefault().cleanLastCompilation(element.getProject());
                ++length;
            }
            ++k;
        }
        this.validResources = new IResource[length];
        int next = 0;
        int k2 = 0;
        while (k2 < resources.length) {
            if (resources[k2] != null) {
                this.validResources[next] = resources[k2];
                ++next;
            }
            ++k2;
        }
    }

    public CompileAdaFilesJob(IResource resource) {
        this(new Object[]{resource});
    }

    protected IStatus run(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.validResources.length) {
            IResource element = (IResource)this.validResources[i];
            if (element instanceof IFile) {
                String compileCommand;
                IProject project = element.getProject();
                try {
                    compileCommand = ToolChain.active().compileCommand(project);
                }
                catch (ToolChain.NoExtensionFound noExtensionFound) {
                    return new Status(4, GNATbenchUIPlugin.getId(), 0, "No toolchain definition was found", null);
                }
                String gprFileLocation = "\"" + GPRProject.getGPROSPath((IProject)project) + "\"";
                String command = String.valueOf(compileCommand) + " -P " + gprFileLocation + " " + element.getName();
                GNATbenchBuilderJob job = new GNATbenchBuilderJob(command, project);
                job.schedule();
                job.addJobChangeListener((IJobChangeListener)new JobCompleteAdapter(project));
            }
            ++i;
        }
        return new Status(0, GNATbenchUIPlugin.getId(), 0, "", null);
    }

    class JobCompleteAdapter
    extends JobChangeAdapter {
        IProject project;

        public JobCompleteAdapter(IProject project) {
            this.project = project;
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                try {
                    this.project.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
                    return;
                }
            }
        }
    }
}

