/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.codingstyle;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.adaeditor.AdaDocumentBuffer;
import com.adacore.gnatbench.library.Case_Handling.Case_Handling_Package;
import com.adacore.gnatbench.library.Language.Ada.Ada_Package;
import com.adacore.gnatbench.library.Language.Replace_Text_Callback;
import com.adacore.gnatbench.library.LibrarySemaphore;
import com.adacore.gnatbench.ui.codingstyle.AdaAutoEditStrategy;
import com.adacore.gnatbench.ui.codingstyle.AdaAutoIndentPreferencesProvider;
import com.adacore.gnatbench.ui.codingstyle.AdaMainAutoEditStrategy;
import com.adacore.jni.AdaString;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;

public class AdaAutoIndent
extends AdaAutoEditStrategy {
    private DefaultIndentLineAutoEditStrategy defaultStrategy = new DefaultIndentLineAutoEditStrategy();
    private int[] fLinesOffsets;
    private int fFirstLine;
    private DocumentCommand fCommand;
    private AdaDocumentBuffer fBuffer;
    private AdaMainAutoEditStrategy fMainStrategy;

    public AdaAutoIndent(AdaDocumentBuffer buffer, AdaMainAutoEditStrategy mainStrategy) {
        this.fBuffer = buffer;
        this.fMainStrategy = mainStrategy;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doAutoIndent(String text, int lineBegin, int lineEnd) {
        int semDepth = LibrarySemaphore.startGPSWork();
        try {
            Ada_Package.Ada_Lang().Format_Buffer(new AdaString(text), (Replace_Text_Callback)new Text_Callback(), lineBegin, lineEnd, GNATbenchCorePlugin.getDefault().getIndentParameters(), 0, Case_Handling_Package.No_Casing_Exception());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            LibrarySemaphore.stopGPSWork((int)semDepth);
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        LibrarySemaphore.stopGPSWork((int)semDepth);
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text.indexOf("\n", 0) == -1) {
            return;
        }
        this.fCommand = command;
        try {
            String indentType = GNATbenchCorePlugin.getDefault().getPreferenceStore().getString(AdaAutoIndentPreferencesProvider.PREF_CODINGSTYLE_AUTOINDENT);
            if ("none".equals(indentType)) {
                this.getWholeLine(document, this.fCommand, this.fBuffer, this.fMainStrategy);
                return;
            }
            if ("simple".equals(indentType)) {
                this.defaultStrategy.customizeDocumentCommand(document, this.fCommand);
                this.getWholeLine(document, this.fCommand, this.fBuffer, this.fMainStrategy);
            } else if ("extended".equals(indentType)) {
                this.getWholeLine(document, this.fCommand, this.fBuffer, this.fMainStrategy);
                String text = String.valueOf(this.fBuffer.getContent().substring(0, this.fCommand.offset)) + this.fCommand.text + "\n";
                this.fFirstLine = document.getLineOfOffset(this.fCommand.offset) + 1;
                int lastInd = 0;
                int nbLines = 0;
                while ((lastInd = this.fCommand.text.indexOf("\n", lastInd) + 1) > 0) {
                    ++nbLines;
                }
                int lastLine = this.fFirstLine + nbLines;
                this.fLinesOffsets = new int[lastLine - this.fFirstLine + 1];
                this.fLinesOffsets[0] = 0;
                lastInd = 0;
                int indOffset = 1;
                while ((lastInd = this.fCommand.text.indexOf("\n", lastInd) + 1) > 0) {
                    this.fLinesOffsets[indOffset] = lastInd;
                    ++indOffset;
                }
                this.doAutoIndent(text, this.fFirstLine, lastLine);
            }
        }
        catch (BadLocationException e) {
            GNATbenchCorePlugin.getDefault().logError(null, (Throwable)e);
        }
    }

    class Text_Callback
    extends Replace_Text_Callback {
        Text_Callback() {
        }

        public void Replace_Text_Callback_Body(int Line, int First2, int Last, AdaString Replace) {
            int offsetBegin = AdaAutoIndent.this.fLinesOffsets[Line - AdaAutoIndent.this.fFirstLine] + First2 - 1;
            int offsetEnd = offsetBegin + Last - First2;
            int diffSize = Replace.toString().length() - (offsetEnd - offsetBegin);
            ((AdaAutoIndent)AdaAutoIndent.this).fCommand.text = String.valueOf(((AdaAutoIndent)AdaAutoIndent.this).fCommand.text.substring(0, offsetBegin)) + Replace.toString() + ((AdaAutoIndent)AdaAutoIndent.this).fCommand.text.substring(offsetEnd);
            int i = Line - AdaAutoIndent.this.fFirstLine + 1;
            while (i < AdaAutoIndent.this.fLinesOffsets.length) {
                int[] nArray = AdaAutoIndent.this.fLinesOffsets;
                int n = i++;
                nArray[n] = nArray[n] + diffSize;
            }
        }
    }
}

