/*
 * Decompiled with CFR 0.152.
 */
package com.adacore.gnatbench.ui.codingstyle;

import com.adacore.gnatbench.core.GNATbenchCorePlugin;
import com.adacore.gnatbench.core.adaeditor.AdaPartitionScanner;
import com.adacore.gnatbench.core.codingstyle.LowerCasing;
import com.adacore.gnatbench.core.codingstyle.MixedCasing;
import com.adacore.gnatbench.core.codingstyle.SmartMixedCasing;
import com.adacore.gnatbench.core.codingstyle.UpperCasing;
import com.adacore.gnatbench.core.utils.SyntaxUtils;
import com.adacore.gnatbench.ui.codingstyle.AdaAutoCasingPreferenceProvider;
import com.adacore.gnatbench.ui.codingstyle.AdaAutoEditStrategy;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class AdaAutoCasing
extends AdaAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        Document tempDocument = new Document();
        tempDocument.set(command.text);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)GNATbenchCorePlugin.getDefault().getPartitionScanner(), AdaPartitionScanner.ADA_PARTITION_TYPES);
        tempDocument.setDocumentPartitioner("__ada_gnatbench_partitioning", (IDocumentPartitioner)partitioner);
        partitioner.connect((IDocument)tempDocument);
        int i = 0;
        while (i < command.text.length()) {
            String contentTypeTempDocument;
            try {
                contentTypeTempDocument = tempDocument.getContentType("__ada_gnatbench_partitioning", i, false);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            catch (BadPartitioningException badPartitioningException) {
                return;
            }
            if (contentTypeTempDocument == "__dftl_partition_content_type") {
                StringBuffer buffer = new StringBuffer(command.text);
                i = this.formatWord(buffer, i);
                command.text = buffer.toString();
            }
            ++i;
        }
    }

    private int formatWord(StringBuffer text, int offset) {
        String word = "";
        int previousChar = 32;
        if (offset > 0) {
            previousChar = text.charAt(offset - 1);
        }
        int lastChar = offset;
        while (lastChar < text.length() && this.isIdPart(text.charAt(lastChar))) {
            word = String.valueOf(word) + text.charAt(lastChar);
            ++lastChar;
        }
        if (lastChar == offset) {
            return offset;
        }
        LowerCasing recaser = null;
        String prefValue = SyntaxUtils.isAdaKeyword((String)word) && previousChar != 39 ? GNATbenchCorePlugin.getDefault().getPreferenceStore().getString(AdaAutoCasingPreferenceProvider.PREF_CODINGSTYLE_AUTOCASING_KEYWORDS) : GNATbenchCorePlugin.getDefault().getPreferenceStore().getString(AdaAutoCasingPreferenceProvider.PREF_CODINGSTYLE_AUTOCASING_IDENTIFIERS);
        if (!prefValue.equals("none")) {
            if (prefValue.equals("lower")) {
                recaser = new LowerCasing();
            } else if (prefValue.equals("mixed")) {
                recaser = new MixedCasing();
            } else if (prefValue.equals("upper")) {
                recaser = new UpperCasing();
            } else if (prefValue.equals("smart")) {
                recaser = new SmartMixedCasing();
            }
            word = recaser.recase(word);
            text.replace(offset, lastChar, word);
        }
        return lastChar - 1;
    }

    private boolean isIdPart(char c) {
        return c == '_' || c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }
}

